/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TableUsageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="secondsInPeriod")
    private final Integer secondsInPeriod;
    @JsonProperty(value="readUnits")
    private final Integer readUnits;
    @JsonProperty(value="writeUnits")
    private final Integer writeUnits;
    @JsonProperty(value="storageInGBs")
    private final Integer storageInGBs;
    @JsonProperty(value="readThrottleCount")
    private final Integer readThrottleCount;
    @JsonProperty(value="writeThrottleCount")
    private final Integer writeThrottleCount;
    @JsonProperty(value="storageThrottleCount")
    private final Integer storageThrottleCount;
    @JsonProperty(value="maxShardSizeUsageInPercent")
    private final Integer maxShardSizeUsageInPercent;

    @Deprecated
    @ConstructorProperties(value={"secondsInPeriod", "readUnits", "writeUnits", "storageInGBs", "readThrottleCount", "writeThrottleCount", "storageThrottleCount", "maxShardSizeUsageInPercent"})
    public TableUsageSummary(Integer secondsInPeriod, Integer readUnits, Integer writeUnits, Integer storageInGBs, Integer readThrottleCount, Integer writeThrottleCount, Integer storageThrottleCount, Integer maxShardSizeUsageInPercent) {
        this.secondsInPeriod = secondsInPeriod;
        this.readUnits = readUnits;
        this.writeUnits = writeUnits;
        this.storageInGBs = storageInGBs;
        this.readThrottleCount = readThrottleCount;
        this.writeThrottleCount = writeThrottleCount;
        this.storageThrottleCount = storageThrottleCount;
        this.maxShardSizeUsageInPercent = maxShardSizeUsageInPercent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getSecondsInPeriod() {
        return this.secondsInPeriod;
    }

    public Integer getReadUnits() {
        return this.readUnits;
    }

    public Integer getWriteUnits() {
        return this.writeUnits;
    }

    public Integer getStorageInGBs() {
        return this.storageInGBs;
    }

    public Integer getReadThrottleCount() {
        return this.readThrottleCount;
    }

    public Integer getWriteThrottleCount() {
        return this.writeThrottleCount;
    }

    public Integer getStorageThrottleCount() {
        return this.storageThrottleCount;
    }

    public Integer getMaxShardSizeUsageInPercent() {
        return this.maxShardSizeUsageInPercent;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TableUsageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("secondsInPeriod=").append(String.valueOf(this.secondsInPeriod));
        sb.append(", readUnits=").append(String.valueOf(this.readUnits));
        sb.append(", writeUnits=").append(String.valueOf(this.writeUnits));
        sb.append(", storageInGBs=").append(String.valueOf(this.storageInGBs));
        sb.append(", readThrottleCount=").append(String.valueOf(this.readThrottleCount));
        sb.append(", writeThrottleCount=").append(String.valueOf(this.writeThrottleCount));
        sb.append(", storageThrottleCount=").append(String.valueOf(this.storageThrottleCount));
        sb.append(", maxShardSizeUsageInPercent=").append(String.valueOf(this.maxShardSizeUsageInPercent));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableUsageSummary)) {
            return false;
        }
        TableUsageSummary other = (TableUsageSummary)((Object)o);
        return Objects.equals(this.secondsInPeriod, other.secondsInPeriod) && Objects.equals(this.readUnits, other.readUnits) && Objects.equals(this.writeUnits, other.writeUnits) && Objects.equals(this.storageInGBs, other.storageInGBs) && Objects.equals(this.readThrottleCount, other.readThrottleCount) && Objects.equals(this.writeThrottleCount, other.writeThrottleCount) && Objects.equals(this.storageThrottleCount, other.storageThrottleCount) && Objects.equals(this.maxShardSizeUsageInPercent, other.maxShardSizeUsageInPercent) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.secondsInPeriod == null ? 43 : this.secondsInPeriod.hashCode());
        result = result * 59 + (this.readUnits == null ? 43 : this.readUnits.hashCode());
        result = result * 59 + (this.writeUnits == null ? 43 : this.writeUnits.hashCode());
        result = result * 59 + (this.storageInGBs == null ? 43 : this.storageInGBs.hashCode());
        result = result * 59 + (this.readThrottleCount == null ? 43 : this.readThrottleCount.hashCode());
        result = result * 59 + (this.writeThrottleCount == null ? 43 : this.writeThrottleCount.hashCode());
        result = result * 59 + (this.storageThrottleCount == null ? 43 : this.storageThrottleCount.hashCode());
        result = result * 59 + (this.maxShardSizeUsageInPercent == null ? 43 : this.maxShardSizeUsageInPercent.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="secondsInPeriod")
        private Integer secondsInPeriod;
        @JsonProperty(value="readUnits")
        private Integer readUnits;
        @JsonProperty(value="writeUnits")
        private Integer writeUnits;
        @JsonProperty(value="storageInGBs")
        private Integer storageInGBs;
        @JsonProperty(value="readThrottleCount")
        private Integer readThrottleCount;
        @JsonProperty(value="writeThrottleCount")
        private Integer writeThrottleCount;
        @JsonProperty(value="storageThrottleCount")
        private Integer storageThrottleCount;
        @JsonProperty(value="maxShardSizeUsageInPercent")
        private Integer maxShardSizeUsageInPercent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder secondsInPeriod(Integer secondsInPeriod) {
            this.secondsInPeriod = secondsInPeriod;
            this.__explicitlySet__.add("secondsInPeriod");
            return this;
        }

        public Builder readUnits(Integer readUnits) {
            this.readUnits = readUnits;
            this.__explicitlySet__.add("readUnits");
            return this;
        }

        public Builder writeUnits(Integer writeUnits) {
            this.writeUnits = writeUnits;
            this.__explicitlySet__.add("writeUnits");
            return this;
        }

        public Builder storageInGBs(Integer storageInGBs) {
            this.storageInGBs = storageInGBs;
            this.__explicitlySet__.add("storageInGBs");
            return this;
        }

        public Builder readThrottleCount(Integer readThrottleCount) {
            this.readThrottleCount = readThrottleCount;
            this.__explicitlySet__.add("readThrottleCount");
            return this;
        }

        public Builder writeThrottleCount(Integer writeThrottleCount) {
            this.writeThrottleCount = writeThrottleCount;
            this.__explicitlySet__.add("writeThrottleCount");
            return this;
        }

        public Builder storageThrottleCount(Integer storageThrottleCount) {
            this.storageThrottleCount = storageThrottleCount;
            this.__explicitlySet__.add("storageThrottleCount");
            return this;
        }

        public Builder maxShardSizeUsageInPercent(Integer maxShardSizeUsageInPercent) {
            this.maxShardSizeUsageInPercent = maxShardSizeUsageInPercent;
            this.__explicitlySet__.add("maxShardSizeUsageInPercent");
            return this;
        }

        public TableUsageSummary build() {
            TableUsageSummary model = new TableUsageSummary(this.secondsInPeriod, this.readUnits, this.writeUnits, this.storageInGBs, this.readThrottleCount, this.writeThrottleCount, this.storageThrottleCount, this.maxShardSizeUsageInPercent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TableUsageSummary model) {
            if (model.wasPropertyExplicitlySet("secondsInPeriod")) {
                this.secondsInPeriod(model.getSecondsInPeriod());
            }
            if (model.wasPropertyExplicitlySet("readUnits")) {
                this.readUnits(model.getReadUnits());
            }
            if (model.wasPropertyExplicitlySet("writeUnits")) {
                this.writeUnits(model.getWriteUnits());
            }
            if (model.wasPropertyExplicitlySet("storageInGBs")) {
                this.storageInGBs(model.getStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("readThrottleCount")) {
                this.readThrottleCount(model.getReadThrottleCount());
            }
            if (model.wasPropertyExplicitlySet("writeThrottleCount")) {
                this.writeThrottleCount(model.getWriteThrottleCount());
            }
            if (model.wasPropertyExplicitlySet("storageThrottleCount")) {
                this.storageThrottleCount(model.getStorageThrottleCount());
            }
            if (model.wasPropertyExplicitlySet("maxShardSizeUsageInPercent")) {
                this.maxShardSizeUsageInPercent(model.getMaxShardSizeUsageInPercent());
            }
            return this;
        }
    }
}

