/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.nosql.model.UpdateTableDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateTableRequest
extends BmcRequest<UpdateTableDetails> {
    private String tableNameOrId;
    private UpdateTableDetails updateTableDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public UpdateTableDetails getUpdateTableDetails() {
        return this.updateTableDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateTableDetails getBody$() {
        return this.updateTableDetails;
    }

    public Builder toBuilder() {
        return new Builder().tableNameOrId(this.tableNameOrId).updateTableDetails(this.updateTableDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tableNameOrId=").append(String.valueOf(this.tableNameOrId));
        sb.append(",updateTableDetails=").append(String.valueOf((Object)this.updateTableDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tableNameOrId, other.tableNameOrId) && Objects.equals((Object)this.updateTableDetails, (Object)other.updateTableDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tableNameOrId == null ? 43 : this.tableNameOrId.hashCode());
        result = result * 59 + (this.updateTableDetails == null ? 43 : this.updateTableDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTableRequest, UpdateTableDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tableNameOrId = null;
        private UpdateTableDetails updateTableDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder updateTableDetails(UpdateTableDetails updateTableDetails) {
            this.updateTableDetails = updateTableDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTableRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.updateTableDetails(o.getUpdateTableDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTableRequest build() {
            UpdateTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTableDetails body) {
            this.updateTableDetails(body);
            return this;
        }

        public UpdateTableRequest buildWithoutInvocationCallback() {
            UpdateTableRequest request = new UpdateTableRequest();
            request.tableNameOrId = this.tableNameOrId;
            request.updateTableDetails = this.updateTableDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

