/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.nosql.model.RequestUsage;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateRowResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="existingVersion")
    private final String existingVersion;
    @JsonProperty(value="existingValue")
    private final Map<String, Object> existingValue;
    @JsonProperty(value="generatedValue")
    private final String generatedValue;
    @JsonProperty(value="usage")
    private final RequestUsage usage;

    @Deprecated
    @ConstructorProperties(value={"version", "existingVersion", "existingValue", "generatedValue", "usage"})
    public UpdateRowResult(String version, String existingVersion, Map<String, Object> existingValue, String generatedValue, RequestUsage usage) {
        this.version = version;
        this.existingVersion = existingVersion;
        this.existingValue = existingValue;
        this.generatedValue = generatedValue;
        this.usage = usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public String getExistingVersion() {
        return this.existingVersion;
    }

    public Map<String, Object> getExistingValue() {
        return this.existingValue;
    }

    public String getGeneratedValue() {
        return this.generatedValue;
    }

    public RequestUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateRowResult(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", existingVersion=").append(String.valueOf(this.existingVersion));
        sb.append(", existingValue=").append(String.valueOf(this.existingValue));
        sb.append(", generatedValue=").append(String.valueOf(this.generatedValue));
        sb.append(", usage=").append(String.valueOf((Object)this.usage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRowResult)) {
            return false;
        }
        UpdateRowResult other = (UpdateRowResult)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.existingVersion, other.existingVersion) && Objects.equals(this.existingValue, other.existingValue) && Objects.equals(this.generatedValue, other.generatedValue) && Objects.equals((Object)this.usage, (Object)other.usage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.existingVersion == null ? 43 : this.existingVersion.hashCode());
        result = result * 59 + (this.existingValue == null ? 43 : this.existingValue.hashCode());
        result = result * 59 + (this.generatedValue == null ? 43 : this.generatedValue.hashCode());
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="existingVersion")
        private String existingVersion;
        @JsonProperty(value="existingValue")
        private Map<String, Object> existingValue;
        @JsonProperty(value="generatedValue")
        private String generatedValue;
        @JsonProperty(value="usage")
        private RequestUsage usage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder existingVersion(String existingVersion) {
            this.existingVersion = existingVersion;
            this.__explicitlySet__.add("existingVersion");
            return this;
        }

        public Builder existingValue(Map<String, Object> existingValue) {
            this.existingValue = existingValue;
            this.__explicitlySet__.add("existingValue");
            return this;
        }

        public Builder generatedValue(String generatedValue) {
            this.generatedValue = generatedValue;
            this.__explicitlySet__.add("generatedValue");
            return this;
        }

        public Builder usage(RequestUsage usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public UpdateRowResult build() {
            UpdateRowResult model = new UpdateRowResult(this.version, this.existingVersion, this.existingValue, this.generatedValue, this.usage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateRowResult model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("existingVersion")) {
                this.existingVersion(model.getExistingVersion());
            }
            if (model.wasPropertyExplicitlySet("existingValue")) {
                this.existingValue(model.getExistingValue());
            }
            if (model.wasPropertyExplicitlySet("generatedValue")) {
                this.generatedValue(model.getGeneratedValue());
            }
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            return this;
        }
    }
}

