/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteIndexRequest
extends BmcRequest<Void> {
    private String tableNameOrId;
    private String indexName;
    private String compartmentId;
    private Boolean isIfExists;
    private String ifMatch;
    private String opcRequestId;

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsIfExists() {
        return this.isIfExists;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().tableNameOrId(this.tableNameOrId).indexName(this.indexName).compartmentId(this.compartmentId).isIfExists(this.isIfExists).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tableNameOrId=").append(String.valueOf(this.tableNameOrId));
        sb.append(",indexName=").append(String.valueOf(this.indexName));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",isIfExists=").append(String.valueOf(this.isIfExists));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteIndexRequest)) {
            return false;
        }
        DeleteIndexRequest other = (DeleteIndexRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tableNameOrId, other.tableNameOrId) && Objects.equals(this.indexName, other.indexName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isIfExists, other.isIfExists) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tableNameOrId == null ? 43 : this.tableNameOrId.hashCode());
        result = result * 59 + (this.indexName == null ? 43 : this.indexName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isIfExists == null ? 43 : this.isIfExists.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteIndexRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tableNameOrId = null;
        private String indexName = null;
        private String compartmentId = null;
        private Boolean isIfExists = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder isIfExists(Boolean isIfExists) {
            this.isIfExists = isIfExists;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteIndexRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.indexName(o.getIndexName());
            this.compartmentId(o.getCompartmentId());
            this.isIfExists(o.getIsIfExists());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteIndexRequest build() {
            DeleteIndexRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteIndexRequest buildWithoutInvocationCallback() {
            DeleteIndexRequest request = new DeleteIndexRequest();
            request.tableNameOrId = this.tableNameOrId;
            request.indexName = this.indexName;
            request.compartmentId = this.compartmentId;
            request.isIfExists = this.isIfExists;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

