/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql;

import com.oracle.bmc.nosql.Nosql;
import com.oracle.bmc.nosql.model.Index;
import com.oracle.bmc.nosql.model.Table;
import com.oracle.bmc.nosql.requests.GetIndexRequest;
import com.oracle.bmc.nosql.requests.GetTableRequest;
import com.oracle.bmc.nosql.requests.GetWorkRequestRequest;
import com.oracle.bmc.nosql.responses.GetIndexResponse;
import com.oracle.bmc.nosql.responses.GetTableResponse;
import com.oracle.bmc.nosql.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class NosqlWaiters {
    private final ExecutorService executorService;
    private final Nosql client;

    public NosqlWaiters(ExecutorService executorService, Nosql client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetIndexRequest, GetIndexResponse> forIndex(GetIndexRequest request, Index.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIndex(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIndexRequest, GetIndexResponse> forIndex(GetIndexRequest request, Index.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIndex(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIndexRequest, GetIndexResponse> forIndex(GetIndexRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Index.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIndex(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIndexRequest, GetIndexResponse> forIndex(BmcGenericWaiter waiter, GetIndexRequest request, Index.LifecycleState ... targetStates) {
        final HashSet<Index.LifecycleState> targetStatesSet = new HashSet<Index.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIndexRequest, GetIndexResponse>(){

            @Override
            public GetIndexResponse apply(GetIndexRequest request) {
                return NosqlWaiters.this.client.getIndex(request);
            }
        }, (Predicate)new Predicate<GetIndexResponse>(){

            @Override
            public boolean test(GetIndexResponse response) {
                return targetStatesSet.contains((Object)response.getIndex().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Index.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTableRequest, GetTableResponse> forTable(GetTableRequest request, Table.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTable(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTableRequest, GetTableResponse> forTable(GetTableRequest request, Table.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTableRequest, GetTableResponse> forTable(GetTableRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Table.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTableRequest, GetTableResponse> forTable(BmcGenericWaiter waiter, GetTableRequest request, Table.LifecycleState ... targetStates) {
        final HashSet<Table.LifecycleState> targetStatesSet = new HashSet<Table.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTableRequest, GetTableResponse>(){

            @Override
            public GetTableResponse apply(GetTableRequest request) {
                return NosqlWaiters.this.client.getTable(request);
            }
        }, (Predicate)new Predicate<GetTableResponse>(){

            @Override
            public boolean test(GetTableResponse response) {
                return targetStatesSet.contains((Object)response.getTable().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Table.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return NosqlWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

