/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateReplicaDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="maxReadUnits")
    private final Integer maxReadUnits;
    @JsonProperty(value="maxWriteUnits")
    private final Integer maxWriteUnits;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "region", "maxReadUnits", "maxWriteUnits"})
    public CreateReplicaDetails(String compartmentId, String region, Integer maxReadUnits, Integer maxWriteUnits) {
        this.compartmentId = compartmentId;
        this.region = region;
        this.maxReadUnits = maxReadUnits;
        this.maxWriteUnits = maxWriteUnits;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getRegion() {
        return this.region;
    }

    public Integer getMaxReadUnits() {
        return this.maxReadUnits;
    }

    public Integer getMaxWriteUnits() {
        return this.maxWriteUnits;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateReplicaDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", maxReadUnits=").append(String.valueOf(this.maxReadUnits));
        sb.append(", maxWriteUnits=").append(String.valueOf(this.maxWriteUnits));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateReplicaDetails)) {
            return false;
        }
        CreateReplicaDetails other = (CreateReplicaDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.region, other.region) && Objects.equals(this.maxReadUnits, other.maxReadUnits) && Objects.equals(this.maxWriteUnits, other.maxWriteUnits) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.maxReadUnits == null ? 43 : this.maxReadUnits.hashCode());
        result = result * 59 + (this.maxWriteUnits == null ? 43 : this.maxWriteUnits.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="maxReadUnits")
        private Integer maxReadUnits;
        @JsonProperty(value="maxWriteUnits")
        private Integer maxWriteUnits;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder maxReadUnits(Integer maxReadUnits) {
            this.maxReadUnits = maxReadUnits;
            this.__explicitlySet__.add("maxReadUnits");
            return this;
        }

        public Builder maxWriteUnits(Integer maxWriteUnits) {
            this.maxWriteUnits = maxWriteUnits;
            this.__explicitlySet__.add("maxWriteUnits");
            return this;
        }

        public CreateReplicaDetails build() {
            CreateReplicaDetails model = new CreateReplicaDetails(this.compartmentId, this.region, this.maxReadUnits, this.maxWriteUnits);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateReplicaDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("maxReadUnits")) {
                this.maxReadUnits(model.getMaxReadUnits());
            }
            if (model.wasPropertyExplicitlySet("maxWriteUnits")) {
                this.maxWriteUnits(model.getMaxWriteUnits());
            }
            return this;
        }
    }
}

