/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Replica
extends ExplicitlySetBmcModel {
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="tableId")
    private final String tableId;
    @JsonProperty(value="maxWriteUnits")
    private final Integer maxWriteUnits;
    @JsonProperty(value="capacityMode")
    private final CapacityMode capacityMode;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;

    @Deprecated
    @ConstructorProperties(value={"region", "tableId", "maxWriteUnits", "capacityMode", "lifecycleState", "lifecycleDetails"})
    public Replica(String region, String tableId, Integer maxWriteUnits, CapacityMode capacityMode, LifecycleState lifecycleState, String lifecycleDetails) {
        this.region = region;
        this.tableId = tableId;
        this.maxWriteUnits = maxWriteUnits;
        this.capacityMode = capacityMode;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRegion() {
        return this.region;
    }

    public String getTableId() {
        return this.tableId;
    }

    public Integer getMaxWriteUnits() {
        return this.maxWriteUnits;
    }

    public CapacityMode getCapacityMode() {
        return this.capacityMode;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Replica(");
        sb.append("super=").append(super.toString());
        sb.append("region=").append(String.valueOf(this.region));
        sb.append(", tableId=").append(String.valueOf(this.tableId));
        sb.append(", maxWriteUnits=").append(String.valueOf(this.maxWriteUnits));
        sb.append(", capacityMode=").append(String.valueOf((Object)this.capacityMode));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Replica)) {
            return false;
        }
        Replica other = (Replica)((Object)o);
        return Objects.equals(this.region, other.region) && Objects.equals(this.tableId, other.tableId) && Objects.equals(this.maxWriteUnits, other.maxWriteUnits) && Objects.equals((Object)this.capacityMode, (Object)other.capacityMode) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.tableId == null ? 43 : this.tableId.hashCode());
        result = result * 59 + (this.maxWriteUnits == null ? 43 : this.maxWriteUnits.hashCode());
        result = result * 59 + (this.capacityMode == null ? 43 : this.capacityMode.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum CapacityMode implements BmcEnum
    {
        Provisioned("PROVISIONED"),
        OnDemand("ON_DEMAND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CapacityMode> map;

        private CapacityMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CapacityMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CapacityMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CapacityMode.class);
            map = new HashMap<String, CapacityMode>();
            for (CapacityMode v : CapacityMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="tableId")
        private String tableId;
        @JsonProperty(value="maxWriteUnits")
        private Integer maxWriteUnits;
        @JsonProperty(value="capacityMode")
        private CapacityMode capacityMode;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder tableId(String tableId) {
            this.tableId = tableId;
            this.__explicitlySet__.add("tableId");
            return this;
        }

        public Builder maxWriteUnits(Integer maxWriteUnits) {
            this.maxWriteUnits = maxWriteUnits;
            this.__explicitlySet__.add("maxWriteUnits");
            return this;
        }

        public Builder capacityMode(CapacityMode capacityMode) {
            this.capacityMode = capacityMode;
            this.__explicitlySet__.add("capacityMode");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Replica build() {
            Replica model = new Replica(this.region, this.tableId, this.maxWriteUnits, this.capacityMode, this.lifecycleState, this.lifecycleDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Replica model) {
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("tableId")) {
                this.tableId(model.getTableId());
            }
            if (model.wasPropertyExplicitlySet("maxWriteUnits")) {
                this.maxWriteUnits(model.getMaxWriteUnits());
            }
            if (model.wasPropertyExplicitlySet("capacityMode")) {
                this.capacityMode(model.getCapacityMode());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            return this;
        }
    }
}

