/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.nosql.model.TableSummary;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TableCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="items")
    private final List<TableSummary> items;
    @JsonProperty(value="maxAutoReclaimableTables")
    private final Integer maxAutoReclaimableTables;
    @JsonProperty(value="autoReclaimableTables")
    private final Integer autoReclaimableTables;
    @JsonProperty(value="onDemandCapacityTables")
    private final Integer onDemandCapacityTables;
    @JsonProperty(value="maxOnDemandCapacityTables")
    private final Integer maxOnDemandCapacityTables;
    @JsonProperty(value="availableReplicationRegions")
    private final List<String> availableReplicationRegions;

    @Deprecated
    @ConstructorProperties(value={"items", "maxAutoReclaimableTables", "autoReclaimableTables", "onDemandCapacityTables", "maxOnDemandCapacityTables", "availableReplicationRegions"})
    public TableCollection(List<TableSummary> items, Integer maxAutoReclaimableTables, Integer autoReclaimableTables, Integer onDemandCapacityTables, Integer maxOnDemandCapacityTables, List<String> availableReplicationRegions) {
        this.items = items;
        this.maxAutoReclaimableTables = maxAutoReclaimableTables;
        this.autoReclaimableTables = autoReclaimableTables;
        this.onDemandCapacityTables = onDemandCapacityTables;
        this.maxOnDemandCapacityTables = maxOnDemandCapacityTables;
        this.availableReplicationRegions = availableReplicationRegions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<TableSummary> getItems() {
        return this.items;
    }

    public Integer getMaxAutoReclaimableTables() {
        return this.maxAutoReclaimableTables;
    }

    public Integer getAutoReclaimableTables() {
        return this.autoReclaimableTables;
    }

    public Integer getOnDemandCapacityTables() {
        return this.onDemandCapacityTables;
    }

    public Integer getMaxOnDemandCapacityTables() {
        return this.maxOnDemandCapacityTables;
    }

    public List<String> getAvailableReplicationRegions() {
        return this.availableReplicationRegions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TableCollection(");
        sb.append("super=").append(super.toString());
        sb.append("items=").append(String.valueOf(this.items));
        sb.append(", maxAutoReclaimableTables=").append(String.valueOf(this.maxAutoReclaimableTables));
        sb.append(", autoReclaimableTables=").append(String.valueOf(this.autoReclaimableTables));
        sb.append(", onDemandCapacityTables=").append(String.valueOf(this.onDemandCapacityTables));
        sb.append(", maxOnDemandCapacityTables=").append(String.valueOf(this.maxOnDemandCapacityTables));
        sb.append(", availableReplicationRegions=").append(String.valueOf(this.availableReplicationRegions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableCollection)) {
            return false;
        }
        TableCollection other = (TableCollection)((Object)o);
        return Objects.equals(this.items, other.items) && Objects.equals(this.maxAutoReclaimableTables, other.maxAutoReclaimableTables) && Objects.equals(this.autoReclaimableTables, other.autoReclaimableTables) && Objects.equals(this.onDemandCapacityTables, other.onDemandCapacityTables) && Objects.equals(this.maxOnDemandCapacityTables, other.maxOnDemandCapacityTables) && Objects.equals(this.availableReplicationRegions, other.availableReplicationRegions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + (this.maxAutoReclaimableTables == null ? 43 : this.maxAutoReclaimableTables.hashCode());
        result = result * 59 + (this.autoReclaimableTables == null ? 43 : this.autoReclaimableTables.hashCode());
        result = result * 59 + (this.onDemandCapacityTables == null ? 43 : this.onDemandCapacityTables.hashCode());
        result = result * 59 + (this.maxOnDemandCapacityTables == null ? 43 : this.maxOnDemandCapacityTables.hashCode());
        result = result * 59 + (this.availableReplicationRegions == null ? 43 : this.availableReplicationRegions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="items")
        private List<TableSummary> items;
        @JsonProperty(value="maxAutoReclaimableTables")
        private Integer maxAutoReclaimableTables;
        @JsonProperty(value="autoReclaimableTables")
        private Integer autoReclaimableTables;
        @JsonProperty(value="onDemandCapacityTables")
        private Integer onDemandCapacityTables;
        @JsonProperty(value="maxOnDemandCapacityTables")
        private Integer maxOnDemandCapacityTables;
        @JsonProperty(value="availableReplicationRegions")
        private List<String> availableReplicationRegions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder items(List<TableSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public Builder maxAutoReclaimableTables(Integer maxAutoReclaimableTables) {
            this.maxAutoReclaimableTables = maxAutoReclaimableTables;
            this.__explicitlySet__.add("maxAutoReclaimableTables");
            return this;
        }

        public Builder autoReclaimableTables(Integer autoReclaimableTables) {
            this.autoReclaimableTables = autoReclaimableTables;
            this.__explicitlySet__.add("autoReclaimableTables");
            return this;
        }

        public Builder onDemandCapacityTables(Integer onDemandCapacityTables) {
            this.onDemandCapacityTables = onDemandCapacityTables;
            this.__explicitlySet__.add("onDemandCapacityTables");
            return this;
        }

        public Builder maxOnDemandCapacityTables(Integer maxOnDemandCapacityTables) {
            this.maxOnDemandCapacityTables = maxOnDemandCapacityTables;
            this.__explicitlySet__.add("maxOnDemandCapacityTables");
            return this;
        }

        public Builder availableReplicationRegions(List<String> availableReplicationRegions) {
            this.availableReplicationRegions = availableReplicationRegions;
            this.__explicitlySet__.add("availableReplicationRegions");
            return this;
        }

        public TableCollection build() {
            TableCollection model = new TableCollection(this.items, this.maxAutoReclaimableTables, this.autoReclaimableTables, this.onDemandCapacityTables, this.maxOnDemandCapacityTables, this.availableReplicationRegions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TableCollection model) {
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            if (model.wasPropertyExplicitlySet("maxAutoReclaimableTables")) {
                this.maxAutoReclaimableTables(model.getMaxAutoReclaimableTables());
            }
            if (model.wasPropertyExplicitlySet("autoReclaimableTables")) {
                this.autoReclaimableTables(model.getAutoReclaimableTables());
            }
            if (model.wasPropertyExplicitlySet("onDemandCapacityTables")) {
                this.onDemandCapacityTables(model.getOnDemandCapacityTables());
            }
            if (model.wasPropertyExplicitlySet("maxOnDemandCapacityTables")) {
                this.maxOnDemandCapacityTables(model.getMaxOnDemandCapacityTables());
            }
            if (model.wasPropertyExplicitlySet("availableReplicationRegions")) {
                this.availableReplicationRegions(model.getAvailableReplicationRegions());
            }
            return this;
        }
    }
}

