/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.nosql.model.RequestUsage;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PreparedStatement
extends ExplicitlySetBmcModel {
    @JsonProperty(value="statement")
    private final String statement;
    @JsonProperty(value="queryPlan")
    private final Object queryPlan;
    @JsonProperty(value="usage")
    private final RequestUsage usage;

    @Deprecated
    @ConstructorProperties(value={"statement", "queryPlan", "usage"})
    public PreparedStatement(String statement, Object queryPlan, RequestUsage usage) {
        this.statement = statement;
        this.queryPlan = queryPlan;
        this.usage = usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStatement() {
        return this.statement;
    }

    public Object getQueryPlan() {
        return this.queryPlan;
    }

    public RequestUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PreparedStatement(");
        sb.append("super=").append(super.toString());
        sb.append("statement=").append(String.valueOf(this.statement));
        sb.append(", queryPlan=").append(String.valueOf(this.queryPlan));
        sb.append(", usage=").append(String.valueOf((Object)this.usage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreparedStatement)) {
            return false;
        }
        PreparedStatement other = (PreparedStatement)((Object)o);
        return Objects.equals(this.statement, other.statement) && Objects.equals(this.queryPlan, other.queryPlan) && Objects.equals((Object)this.usage, (Object)other.usage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.statement == null ? 43 : this.statement.hashCode());
        result = result * 59 + (this.queryPlan == null ? 43 : this.queryPlan.hashCode());
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="statement")
        private String statement;
        @JsonProperty(value="queryPlan")
        private Object queryPlan;
        @JsonProperty(value="usage")
        private RequestUsage usage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder statement(String statement) {
            this.statement = statement;
            this.__explicitlySet__.add("statement");
            return this;
        }

        public Builder queryPlan(Object queryPlan) {
            this.queryPlan = queryPlan;
            this.__explicitlySet__.add("queryPlan");
            return this;
        }

        public Builder usage(RequestUsage usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public PreparedStatement build() {
            PreparedStatement model = new PreparedStatement(this.statement, this.queryPlan, this.usage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PreparedStatement model) {
            if (model.wasPropertyExplicitlySet("statement")) {
                this.statement(model.getStatement());
            }
            if (model.wasPropertyExplicitlySet("queryPlan")) {
                this.queryPlan(model.getQueryPlan());
            }
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            return this;
        }
    }
}

