/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql;

import com.oracle.bmc.nosql.Nosql;
import com.oracle.bmc.nosql.model.IndexSummary;
import com.oracle.bmc.nosql.model.TableSummary;
import com.oracle.bmc.nosql.model.TableUsageSummary;
import com.oracle.bmc.nosql.model.WorkRequestError;
import com.oracle.bmc.nosql.model.WorkRequestLogEntry;
import com.oracle.bmc.nosql.model.WorkRequestSummary;
import com.oracle.bmc.nosql.requests.ListIndexesRequest;
import com.oracle.bmc.nosql.requests.ListTableUsageRequest;
import com.oracle.bmc.nosql.requests.ListTablesRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.nosql.requests.ListWorkRequestsRequest;
import com.oracle.bmc.nosql.responses.ListIndexesResponse;
import com.oracle.bmc.nosql.responses.ListTableUsageResponse;
import com.oracle.bmc.nosql.responses.ListTablesResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.nosql.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class NosqlPaginators {
    private final Nosql client;

    public NosqlPaginators(Nosql client) {
        this.client = client;
    }

    public Iterable<ListIndexesResponse> listIndexesResponseIterator(final ListIndexesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListIndexesRequest.Builder>(){

            @Override
            public ListIndexesRequest.Builder get() {
                return ListIndexesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIndexesResponse, String>(){

            @Override
            public String apply(ListIndexesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIndexesRequest.Builder>, ListIndexesRequest>(){

            @Override
            public ListIndexesRequest apply(RequestBuilderAndToken<ListIndexesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIndexesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIndexesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIndexesRequest, ListIndexesResponse>(){

            @Override
            public ListIndexesResponse apply(ListIndexesRequest request) {
                return NosqlPaginators.this.client.listIndexes(request);
            }
        });
    }

    public Iterable<IndexSummary> listIndexesRecordIterator(final ListIndexesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListIndexesRequest.Builder>(){

            @Override
            public ListIndexesRequest.Builder get() {
                return ListIndexesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListIndexesResponse, String>(){

            @Override
            public String apply(ListIndexesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListIndexesRequest.Builder>, ListIndexesRequest>(){

            @Override
            public ListIndexesRequest apply(RequestBuilderAndToken<ListIndexesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListIndexesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListIndexesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListIndexesRequest, ListIndexesResponse>(){

            @Override
            public ListIndexesResponse apply(ListIndexesRequest request) {
                return NosqlPaginators.this.client.listIndexes(request);
            }
        }, (Function)new Function<ListIndexesResponse, List<IndexSummary>>(){

            @Override
            public List<IndexSummary> apply(ListIndexesResponse response) {
                return response.getIndexCollection().getItems();
            }
        });
    }

    public Iterable<ListTableUsageResponse> listTableUsageResponseIterator(final ListTableUsageRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTableUsageRequest.Builder>(){

            @Override
            public ListTableUsageRequest.Builder get() {
                return ListTableUsageRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTableUsageResponse, String>(){

            @Override
            public String apply(ListTableUsageResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTableUsageRequest.Builder>, ListTableUsageRequest>(){

            @Override
            public ListTableUsageRequest apply(RequestBuilderAndToken<ListTableUsageRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTableUsageRequest, ListTableUsageResponse>(){

            @Override
            public ListTableUsageResponse apply(ListTableUsageRequest request) {
                return NosqlPaginators.this.client.listTableUsage(request);
            }
        });
    }

    public Iterable<TableUsageSummary> listTableUsageRecordIterator(final ListTableUsageRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTableUsageRequest.Builder>(){

            @Override
            public ListTableUsageRequest.Builder get() {
                return ListTableUsageRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTableUsageResponse, String>(){

            @Override
            public String apply(ListTableUsageResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTableUsageRequest.Builder>, ListTableUsageRequest>(){

            @Override
            public ListTableUsageRequest apply(RequestBuilderAndToken<ListTableUsageRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTableUsageRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTableUsageRequest, ListTableUsageResponse>(){

            @Override
            public ListTableUsageResponse apply(ListTableUsageRequest request) {
                return NosqlPaginators.this.client.listTableUsage(request);
            }
        }, (Function)new Function<ListTableUsageResponse, List<TableUsageSummary>>(){

            @Override
            public List<TableUsageSummary> apply(ListTableUsageResponse response) {
                return response.getTableUsageCollection().getItems();
            }
        });
    }

    public Iterable<ListTablesResponse> listTablesResponseIterator(final ListTablesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTablesRequest.Builder>(){

            @Override
            public ListTablesRequest.Builder get() {
                return ListTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTablesResponse, String>(){

            @Override
            public String apply(ListTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTablesRequest.Builder>, ListTablesRequest>(){

            @Override
            public ListTablesRequest apply(RequestBuilderAndToken<ListTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTablesRequest, ListTablesResponse>(){

            @Override
            public ListTablesResponse apply(ListTablesRequest request) {
                return NosqlPaginators.this.client.listTables(request);
            }
        });
    }

    public Iterable<TableSummary> listTablesRecordIterator(final ListTablesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTablesRequest.Builder>(){

            @Override
            public ListTablesRequest.Builder get() {
                return ListTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTablesResponse, String>(){

            @Override
            public String apply(ListTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTablesRequest.Builder>, ListTablesRequest>(){

            @Override
            public ListTablesRequest apply(RequestBuilderAndToken<ListTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTablesRequest, ListTablesResponse>(){

            @Override
            public ListTablesResponse apply(ListTablesRequest request) {
                return NosqlPaginators.this.client.listTables(request);
            }
        }, (Function)new Function<ListTablesResponse, List<TableSummary>>(){

            @Override
            public List<TableSummary> apply(ListTablesResponse response) {
                return response.getTableCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return NosqlPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NosqlPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return NosqlPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

