/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.nosql.model.CreateIndexDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateIndexRequest
extends BmcRequest<CreateIndexDetails> {
    private String tableNameOrId;
    private CreateIndexDetails createIndexDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getTableNameOrId() {
        return this.tableNameOrId;
    }

    public CreateIndexDetails getCreateIndexDetails() {
        return this.createIndexDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateIndexDetails getBody$() {
        return this.createIndexDetails;
    }

    public Builder toBuilder() {
        return new Builder().tableNameOrId(this.tableNameOrId).createIndexDetails(this.createIndexDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tableNameOrId=").append(String.valueOf(this.tableNameOrId));
        sb.append(",createIndexDetails=").append(String.valueOf((Object)this.createIndexDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tableNameOrId, other.tableNameOrId) && Objects.equals((Object)this.createIndexDetails, (Object)other.createIndexDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tableNameOrId == null ? 43 : this.tableNameOrId.hashCode());
        result = result * 59 + (this.createIndexDetails == null ? 43 : this.createIndexDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateIndexRequest, CreateIndexDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tableNameOrId = null;
        private CreateIndexDetails createIndexDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder tableNameOrId(String tableNameOrId) {
            this.tableNameOrId = tableNameOrId;
            return this;
        }

        public Builder createIndexDetails(CreateIndexDetails createIndexDetails) {
            this.createIndexDetails = createIndexDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateIndexRequest o) {
            this.tableNameOrId(o.getTableNameOrId());
            this.createIndexDetails(o.getCreateIndexDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateIndexRequest build() {
            CreateIndexRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateIndexDetails body) {
            this.createIndexDetails(body);
            return this;
        }

        public CreateIndexRequest buildWithoutInvocationCallback() {
            CreateIndexRequest request = new CreateIndexRequest();
            request.tableNameOrId = this.tableNameOrId;
            request.createIndexDetails = this.createIndexDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

