/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.oce.OceInstance;
import com.oracle.bmc.oce.OceInstancePaginators;
import com.oracle.bmc.oce.OceInstanceWaiters;
import com.oracle.bmc.oce.internal.http.ChangeOceInstanceCompartmentConverter;
import com.oracle.bmc.oce.internal.http.CreateOceInstanceConverter;
import com.oracle.bmc.oce.internal.http.DeleteOceInstanceConverter;
import com.oracle.bmc.oce.internal.http.GetOceInstanceConverter;
import com.oracle.bmc.oce.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.oce.internal.http.ListOceInstancesConverter;
import com.oracle.bmc.oce.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.oce.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.oce.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.oce.internal.http.UpdateOceInstanceConverter;
import com.oracle.bmc.oce.requests.ChangeOceInstanceCompartmentRequest;
import com.oracle.bmc.oce.requests.CreateOceInstanceRequest;
import com.oracle.bmc.oce.requests.DeleteOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetWorkRequestRequest;
import com.oracle.bmc.oce.requests.ListOceInstancesRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oce.requests.UpdateOceInstanceRequest;
import com.oracle.bmc.oce.responses.ChangeOceInstanceCompartmentResponse;
import com.oracle.bmc.oce.responses.CreateOceInstanceResponse;
import com.oracle.bmc.oce.responses.DeleteOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetWorkRequestResponse;
import com.oracle.bmc.oce.responses.ListOceInstancesResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestsResponse;
import com.oracle.bmc.oce.responses.UpdateOceInstanceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceInstanceClient
implements OceInstance {
    private static final Logger LOG = LoggerFactory.getLogger(OceInstanceClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCEINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://cp.oce.{region}.ocp.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final OceInstanceWaiters waiters;
    private final OceInstancePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public OceInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OceInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OceInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public OceInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("OceInstance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OceInstanceWaiters(executorService, this);
        this.paginators = new OceInstancePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeOceInstanceCompartmentResponse changeOceInstanceCompartment(ChangeOceInstanceCompartmentRequest request) {
        LOG.trace("Called changeOceInstanceCompartment");
        ChangeOceInstanceCompartmentRequest interceptedRequest = ChangeOceInstanceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeOceInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeOceInstanceCompartmentResponse> transformer = ChangeOceInstanceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeOceInstanceCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeOceInstanceCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeOceInstanceCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeOceInstanceCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateOceInstanceResponse createOceInstance(CreateOceInstanceRequest request) {
        LOG.trace("Called createOceInstance");
        CreateOceInstanceRequest interceptedRequest = CreateOceInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOceInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOceInstanceResponse> transformer = CreateOceInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateOceInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateOceInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateOceInstanceDetails(), (BmcRequest)retriedRequest);
                return (CreateOceInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteOceInstanceResponse deleteOceInstance(DeleteOceInstanceRequest request) {
        LOG.trace("Called deleteOceInstance");
        DeleteOceInstanceRequest interceptedRequest = DeleteOceInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteOceInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteOceInstanceResponse> transformer = DeleteOceInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteOceInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteOceInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteOceInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetOceInstanceResponse getOceInstance(GetOceInstanceRequest request) {
        LOG.trace("Called getOceInstance");
        GetOceInstanceRequest interceptedRequest = GetOceInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetOceInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetOceInstanceResponse> transformer = GetOceInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetOceInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetOceInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetOceInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListOceInstancesResponse listOceInstances(ListOceInstancesRequest request) {
        LOG.trace("Called listOceInstances");
        ListOceInstancesRequest interceptedRequest = ListOceInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListOceInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListOceInstancesResponse> transformer = ListOceInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListOceInstancesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListOceInstancesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListOceInstancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateOceInstanceResponse updateOceInstance(UpdateOceInstanceRequest request) {
        LOG.trace("Called updateOceInstance");
        UpdateOceInstanceRequest interceptedRequest = UpdateOceInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOceInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOceInstanceResponse> transformer = UpdateOceInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateOceInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateOceInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateOceInstanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateOceInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public OceInstanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OceInstancePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OceInstanceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OceInstanceClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new OceInstanceClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

