/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce.responses;

import com.oracle.bmc.oce.model.OceInstance;
import java.beans.ConstructorProperties;

public class GetOceInstanceResponse {
    private String etag;
    private String opcRequestId;
    private OceInstance oceInstance;

    @ConstructorProperties(value={"etag", "opcRequestId", "oceInstance"})
    GetOceInstanceResponse(String etag, String opcRequestId, OceInstance oceInstance) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.oceInstance = oceInstance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public OceInstance getOceInstance() {
        return this.oceInstance;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private OceInstance oceInstance;

        public Builder copy(GetOceInstanceResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.oceInstance(o.getOceInstance());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder oceInstance(OceInstance oceInstance) {
            this.oceInstance = oceInstance;
            return this;
        }

        public GetOceInstanceResponse build() {
            return new GetOceInstanceResponse(this.etag, this.opcRequestId, this.oceInstance);
        }

        public String toString() {
            return "GetOceInstanceResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", oceInstance=" + this.oceInstance + ")";
        }
    }
}

