/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce.responses;

import com.oracle.bmc.oce.model.OceInstanceSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListOceInstancesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<OceInstanceSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListOceInstancesResponse(String opcRequestId, String opcNextPage, List<OceInstanceSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<OceInstanceSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<OceInstanceSummary> items;

        public Builder copy(ListOceInstancesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<OceInstanceSummary> items) {
            this.items = items;
            return this;
        }

        public ListOceInstancesResponse build() {
            return new ListOceInstancesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListOceInstancesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

