/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce.responses;

import com.oracle.bmc.oce.model.WorkRequestLogEntry;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWorkRequestLogsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<WorkRequestLogEntry> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListWorkRequestLogsResponse(String opcNextPage, String opcRequestId, List<WorkRequestLogEntry> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<WorkRequestLogEntry> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<WorkRequestLogEntry> items;

        public Builder copy(ListWorkRequestLogsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<WorkRequestLogEntry> items) {
            this.items = items;
            return this;
        }

        public ListWorkRequestLogsResponse build() {
            return new ListWorkRequestLogsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListWorkRequestLogsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

