/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.oce.OceInstanceAsync;
import com.oracle.bmc.oce.model.OceInstance;
import com.oracle.bmc.oce.model.OceInstanceSummary;
import com.oracle.bmc.oce.model.WorkRequest;
import com.oracle.bmc.oce.model.WorkRequestError;
import com.oracle.bmc.oce.model.WorkRequestLogEntry;
import com.oracle.bmc.oce.requests.ChangeOceInstanceCompartmentRequest;
import com.oracle.bmc.oce.requests.CreateOceInstanceRequest;
import com.oracle.bmc.oce.requests.DeleteOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetWorkRequestRequest;
import com.oracle.bmc.oce.requests.ListOceInstancesRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oce.requests.UpdateOceInstanceRequest;
import com.oracle.bmc.oce.responses.ChangeOceInstanceCompartmentResponse;
import com.oracle.bmc.oce.responses.CreateOceInstanceResponse;
import com.oracle.bmc.oce.responses.DeleteOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetWorkRequestResponse;
import com.oracle.bmc.oce.responses.ListOceInstancesResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestsResponse;
import com.oracle.bmc.oce.responses.UpdateOceInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceInstanceAsyncClient
extends BaseAsyncClient
implements OceInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCEINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://cp.oce.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OceInstanceAsyncClient.class);

    OceInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeOceInstanceCompartmentResponse> changeOceInstanceCompartment(ChangeOceInstanceCompartmentRequest request, AsyncHandler<ChangeOceInstanceCompartmentRequest, ChangeOceInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOceInstanceCompartmentDetails(), "changeOceInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeOceInstanceCompartmentResponse::builder).logger(LOG, "changeOceInstanceCompartment").serviceDetails("OceInstance", "ChangeOceInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/ChangeOceInstanceCompartment").method(Method.POST).requestBuilder(ChangeOceInstanceCompartmentRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeOceInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeOceInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOceInstanceResponse> createOceInstance(CreateOceInstanceRequest request, AsyncHandler<CreateOceInstanceRequest, CreateOceInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateOceInstanceDetails(), "createOceInstanceDetails is required");
        return this.clientCall(request, CreateOceInstanceResponse::builder).logger(LOG, "createOceInstance").serviceDetails("OceInstance", "CreateOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/CreateOceInstance").method(Method.POST).requestBuilder(CreateOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateOceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOceInstanceResponse> deleteOceInstance(DeleteOceInstanceRequest request, AsyncHandler<DeleteOceInstanceRequest, DeleteOceInstanceResponse> handler) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOceInstanceResponse::builder).logger(LOG, "deleteOceInstance").serviceDetails("OceInstance", "DeleteOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/DeleteOceInstance").method(Method.DELETE).requestBuilder(DeleteOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOceInstanceResponse> getOceInstance(GetOceInstanceRequest request, AsyncHandler<GetOceInstanceRequest, GetOceInstanceResponse> handler) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOceInstanceResponse::builder).logger(LOG, "getOceInstance").serviceDetails("OceInstance", "GetOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/GetOceInstance").method(Method.GET).requestBuilder(GetOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OceInstance.class, GetOceInstanceResponse.Builder::oceInstance).handleResponseHeaderString("etag", GetOceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("OceInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListOceInstancesResponse> listOceInstances(ListOceInstancesRequest request, AsyncHandler<ListOceInstancesRequest, ListOceInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListOceInstancesResponse::builder).logger(LOG, "listOceInstances").serviceDetails("OceInstance", "ListOceInstances", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstanceSummary/ListOceInstances").method(Method.GET).requestBuilder(ListOceInstancesRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendQueryParam("tenancyId", (Object)request.getTenancyId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(OceInstanceSummary.class, ListOceInstancesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListOceInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOceInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("OceInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("OceInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("OceInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190912").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateOceInstanceResponse> updateOceInstance(UpdateOceInstanceRequest request, AsyncHandler<UpdateOceInstanceRequest, UpdateOceInstanceResponse> handler) {
        Validate.notBlank((String)request.getOceInstanceId(), (String)"oceInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOceInstanceDetails(), "updateOceInstanceDetails is required");
        return this.clientCall(request, UpdateOceInstanceResponse::builder).logger(LOG, "updateOceInstance").serviceDetails("OceInstance", "UpdateOceInstance", "https://docs.oracle.com/iaas/api/#/en/oce/20190912/OceInstance/UpdateOceInstance").method(Method.PUT).requestBuilder(UpdateOceInstanceRequest::builder).basePath("/20190912").appendPathParam("oceInstances").appendPathParam(request.getOceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OceInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OceInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OceInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OceInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OceInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OceInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OceInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OceInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OceInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OceInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OceInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OceInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OceInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OceInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OceInstanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "oce";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"oce");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OceInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OceInstanceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

