/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.oce.model.LicenseType;
import com.oracle.bmc.oce.model.LifecycleDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateOceInstanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="wafPrimaryDomain")
    private final String wafPrimaryDomain;
    @JsonProperty(value="instanceLicenseType")
    private final LicenseType instanceLicenseType;
    @JsonProperty(value="instanceUsageType")
    private final InstanceUsageType instanceUsageType;
    @JsonProperty(value="addOnFeatures")
    private final List<String> addOnFeatures;
    @JsonProperty(value="lifecycleDetails")
    private final LifecycleDetails lifecycleDetails;
    @JsonProperty(value="drRegion")
    private final String drRegion;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"description", "wafPrimaryDomain", "instanceLicenseType", "instanceUsageType", "addOnFeatures", "lifecycleDetails", "drRegion", "freeformTags", "definedTags"})
    public UpdateOceInstanceDetails(String description, String wafPrimaryDomain, LicenseType instanceLicenseType, InstanceUsageType instanceUsageType, List<String> addOnFeatures, LifecycleDetails lifecycleDetails, String drRegion, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.description = description;
        this.wafPrimaryDomain = wafPrimaryDomain;
        this.instanceLicenseType = instanceLicenseType;
        this.instanceUsageType = instanceUsageType;
        this.addOnFeatures = addOnFeatures;
        this.lifecycleDetails = lifecycleDetails;
        this.drRegion = drRegion;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getWafPrimaryDomain() {
        return this.wafPrimaryDomain;
    }

    public LicenseType getInstanceLicenseType() {
        return this.instanceLicenseType;
    }

    public InstanceUsageType getInstanceUsageType() {
        return this.instanceUsageType;
    }

    public List<String> getAddOnFeatures() {
        return this.addOnFeatures;
    }

    public LifecycleDetails getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getDrRegion() {
        return this.drRegion;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateOceInstanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", wafPrimaryDomain=").append(String.valueOf(this.wafPrimaryDomain));
        sb.append(", instanceLicenseType=").append(String.valueOf((Object)this.instanceLicenseType));
        sb.append(", instanceUsageType=").append(String.valueOf((Object)this.instanceUsageType));
        sb.append(", addOnFeatures=").append(String.valueOf(this.addOnFeatures));
        sb.append(", lifecycleDetails=").append(String.valueOf((Object)this.lifecycleDetails));
        sb.append(", drRegion=").append(String.valueOf(this.drRegion));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateOceInstanceDetails)) {
            return false;
        }
        UpdateOceInstanceDetails other = (UpdateOceInstanceDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.wafPrimaryDomain, other.wafPrimaryDomain) && Objects.equals((Object)this.instanceLicenseType, (Object)other.instanceLicenseType) && Objects.equals((Object)this.instanceUsageType, (Object)other.instanceUsageType) && Objects.equals(this.addOnFeatures, other.addOnFeatures) && Objects.equals((Object)this.lifecycleDetails, (Object)other.lifecycleDetails) && Objects.equals(this.drRegion, other.drRegion) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.wafPrimaryDomain == null ? 43 : this.wafPrimaryDomain.hashCode());
        result = result * 59 + (this.instanceLicenseType == null ? 43 : this.instanceLicenseType.hashCode());
        result = result * 59 + (this.instanceUsageType == null ? 43 : this.instanceUsageType.hashCode());
        result = result * 59 + (this.addOnFeatures == null ? 43 : this.addOnFeatures.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.drRegion == null ? 43 : this.drRegion.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum InstanceUsageType implements BmcEnum
    {
        Primary("PRIMARY"),
        Nonprimary("NONPRIMARY");

        private final String value;
        private static Map<String, InstanceUsageType> map;

        private InstanceUsageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InstanceUsageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid InstanceUsageType: " + key);
        }

        static {
            map = new HashMap<String, InstanceUsageType>();
            for (InstanceUsageType v : InstanceUsageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="wafPrimaryDomain")
        private String wafPrimaryDomain;
        @JsonProperty(value="instanceLicenseType")
        private LicenseType instanceLicenseType;
        @JsonProperty(value="instanceUsageType")
        private InstanceUsageType instanceUsageType;
        @JsonProperty(value="addOnFeatures")
        private List<String> addOnFeatures;
        @JsonProperty(value="lifecycleDetails")
        private LifecycleDetails lifecycleDetails;
        @JsonProperty(value="drRegion")
        private String drRegion;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder wafPrimaryDomain(String wafPrimaryDomain) {
            this.wafPrimaryDomain = wafPrimaryDomain;
            this.__explicitlySet__.add("wafPrimaryDomain");
            return this;
        }

        public Builder instanceLicenseType(LicenseType instanceLicenseType) {
            this.instanceLicenseType = instanceLicenseType;
            this.__explicitlySet__.add("instanceLicenseType");
            return this;
        }

        public Builder instanceUsageType(InstanceUsageType instanceUsageType) {
            this.instanceUsageType = instanceUsageType;
            this.__explicitlySet__.add("instanceUsageType");
            return this;
        }

        public Builder addOnFeatures(List<String> addOnFeatures) {
            this.addOnFeatures = addOnFeatures;
            this.__explicitlySet__.add("addOnFeatures");
            return this;
        }

        public Builder lifecycleDetails(LifecycleDetails lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder drRegion(String drRegion) {
            this.drRegion = drRegion;
            this.__explicitlySet__.add("drRegion");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateOceInstanceDetails build() {
            UpdateOceInstanceDetails model = new UpdateOceInstanceDetails(this.description, this.wafPrimaryDomain, this.instanceLicenseType, this.instanceUsageType, this.addOnFeatures, this.lifecycleDetails, this.drRegion, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateOceInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("wafPrimaryDomain")) {
                this.wafPrimaryDomain(model.getWafPrimaryDomain());
            }
            if (model.wasPropertyExplicitlySet("instanceLicenseType")) {
                this.instanceLicenseType(model.getInstanceLicenseType());
            }
            if (model.wasPropertyExplicitlySet("instanceUsageType")) {
                this.instanceUsageType(model.getInstanceUsageType());
            }
            if (model.wasPropertyExplicitlySet("addOnFeatures")) {
                this.addOnFeatures(model.getAddOnFeatures());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("drRegion")) {
                this.drRegion(model.getDrRegion());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

