/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocicontrolcenter;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.ocicontrolcenter.OccMetricsAsync;
import com.oracle.bmc.ocicontrolcenter.model.MetricPropertyCollection;
import com.oracle.bmc.ocicontrolcenter.model.NamespaceCollection;
import com.oracle.bmc.ocicontrolcenter.model.SummarizedMetricDataCollection;
import com.oracle.bmc.ocicontrolcenter.requests.ListMetricPropertiesRequest;
import com.oracle.bmc.ocicontrolcenter.requests.ListNamespacesRequest;
import com.oracle.bmc.ocicontrolcenter.requests.RequestSummarizedMetricDataRequest;
import com.oracle.bmc.ocicontrolcenter.responses.ListMetricPropertiesResponse;
import com.oracle.bmc.ocicontrolcenter.responses.ListNamespacesResponse;
import com.oracle.bmc.ocicontrolcenter.responses.RequestSummarizedMetricDataResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccMetricsAsyncClient
extends BaseAsyncClient
implements OccMetricsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCCMETRICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://control-center.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OccMetricsAsyncClient.class);

    OccMetricsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ListMetricPropertiesResponse> listMetricProperties(ListMetricPropertiesRequest request, AsyncHandler<ListMetricPropertiesRequest, ListMetricPropertiesResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListMetricPropertiesResponse::builder).logger(LOG, "listMetricProperties").serviceDetails("OccMetrics", "ListMetricProperties", "https://docs.oracle.com/iaas/api/#/en/occ/20230515/MetricPropertyCollection/ListMetricProperties").method(Method.GET).requestBuilder(ListMetricPropertiesRequest::builder).basePath("/20230515").appendPathParam("metricProperties").appendPathParam(request.getNamespaceName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricPropertyCollection.class, ListMetricPropertiesResponse.Builder::metricPropertyCollection).handleResponseHeaderString("opc-request-id", ListMetricPropertiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMetricPropertiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListNamespacesResponse> listNamespaces(ListNamespacesRequest request, AsyncHandler<ListNamespacesRequest, ListNamespacesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNamespacesResponse::builder).logger(LOG, "listNamespaces").serviceDetails("OccMetrics", "ListNamespaces", "https://docs.oracle.com/iaas/api/#/en/occ/20230515/NamespaceCollection/ListNamespaces").method(Method.GET).requestBuilder(ListNamespacesRequest::builder).basePath("/20230515").appendPathParam("namespaces").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NamespaceCollection.class, ListNamespacesResponse.Builder::namespaceCollection).handleResponseHeaderString("opc-request-id", ListNamespacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNamespacesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RequestSummarizedMetricDataResponse> requestSummarizedMetricData(RequestSummarizedMetricDataRequest request, AsyncHandler<RequestSummarizedMetricDataRequest, RequestSummarizedMetricDataResponse> handler) {
        Objects.requireNonNull(request.getRequestSummarizedMetricDataDetails(), "requestSummarizedMetricDataDetails is required");
        return this.clientCall(request, RequestSummarizedMetricDataResponse::builder).logger(LOG, "requestSummarizedMetricData").serviceDetails("OccMetrics", "RequestSummarizedMetricData", "https://docs.oracle.com/iaas/api/#/en/occ/20230515/SummarizedMetricDataCollection/RequestSummarizedMetricData").method(Method.POST).requestBuilder(RequestSummarizedMetricDataRequest::builder).basePath("/20230515").appendPathParam("requestSummarizedMetricData").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SummarizedMetricDataCollection.class, RequestSummarizedMetricDataResponse.Builder::summarizedMetricDataCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedMetricDataResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedMetricDataResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Deprecated
    public OccMetricsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OccMetricsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OccMetricsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OccMetricsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OccMetricsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OccMetricsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OccMetricsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OccMetricsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OccMetricsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OccMetricsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OccMetricsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OccMetricsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OccMetricsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OccMetricsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OccMetricsAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "ocicontrolcenter";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ocicontrolcenter");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OccMetricsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OccMetricsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

