/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocicontrolcenter;

import com.oracle.bmc.ocicontrolcenter.OccMetrics;
import com.oracle.bmc.ocicontrolcenter.model.MetricPropertySummary;
import com.oracle.bmc.ocicontrolcenter.model.NamespaceSummary;
import com.oracle.bmc.ocicontrolcenter.requests.ListMetricPropertiesRequest;
import com.oracle.bmc.ocicontrolcenter.requests.ListNamespacesRequest;
import com.oracle.bmc.ocicontrolcenter.responses.ListMetricPropertiesResponse;
import com.oracle.bmc.ocicontrolcenter.responses.ListNamespacesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OccMetricsPaginators {
    private final OccMetrics client;

    public OccMetricsPaginators(OccMetrics client) {
        this.client = client;
    }

    public Iterable<ListMetricPropertiesResponse> listMetricPropertiesResponseIterator(final ListMetricPropertiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMetricPropertiesRequest.Builder>(){

            @Override
            public ListMetricPropertiesRequest.Builder get() {
                return ListMetricPropertiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMetricPropertiesResponse, String>(){

            @Override
            public String apply(ListMetricPropertiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMetricPropertiesRequest.Builder>, ListMetricPropertiesRequest>(){

            @Override
            public ListMetricPropertiesRequest apply(RequestBuilderAndToken<ListMetricPropertiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMetricPropertiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMetricPropertiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMetricPropertiesRequest, ListMetricPropertiesResponse>(){

            @Override
            public ListMetricPropertiesResponse apply(ListMetricPropertiesRequest request) {
                return OccMetricsPaginators.this.client.listMetricProperties(request);
            }
        });
    }

    public Iterable<MetricPropertySummary> listMetricPropertiesRecordIterator(final ListMetricPropertiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMetricPropertiesRequest.Builder>(){

            @Override
            public ListMetricPropertiesRequest.Builder get() {
                return ListMetricPropertiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMetricPropertiesResponse, String>(){

            @Override
            public String apply(ListMetricPropertiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMetricPropertiesRequest.Builder>, ListMetricPropertiesRequest>(){

            @Override
            public ListMetricPropertiesRequest apply(RequestBuilderAndToken<ListMetricPropertiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMetricPropertiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMetricPropertiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMetricPropertiesRequest, ListMetricPropertiesResponse>(){

            @Override
            public ListMetricPropertiesResponse apply(ListMetricPropertiesRequest request) {
                return OccMetricsPaginators.this.client.listMetricProperties(request);
            }
        }, (Function)new Function<ListMetricPropertiesResponse, List<MetricPropertySummary>>(){

            @Override
            public List<MetricPropertySummary> apply(ListMetricPropertiesResponse response) {
                return response.getMetricPropertyCollection().getItems();
            }
        });
    }

    public Iterable<ListNamespacesResponse> listNamespacesResponseIterator(final ListNamespacesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNamespacesRequest.Builder>(){

            @Override
            public ListNamespacesRequest.Builder get() {
                return ListNamespacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNamespacesResponse, String>(){

            @Override
            public String apply(ListNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNamespacesRequest.Builder>, ListNamespacesRequest>(){

            @Override
            public ListNamespacesRequest apply(RequestBuilderAndToken<ListNamespacesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNamespacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNamespacesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNamespacesRequest, ListNamespacesResponse>(){

            @Override
            public ListNamespacesResponse apply(ListNamespacesRequest request) {
                return OccMetricsPaginators.this.client.listNamespaces(request);
            }
        });
    }

    public Iterable<NamespaceSummary> listNamespacesRecordIterator(final ListNamespacesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNamespacesRequest.Builder>(){

            @Override
            public ListNamespacesRequest.Builder get() {
                return ListNamespacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNamespacesResponse, String>(){

            @Override
            public String apply(ListNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNamespacesRequest.Builder>, ListNamespacesRequest>(){

            @Override
            public ListNamespacesRequest apply(RequestBuilderAndToken<ListNamespacesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNamespacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNamespacesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNamespacesRequest, ListNamespacesResponse>(){

            @Override
            public ListNamespacesResponse apply(ListNamespacesRequest request) {
                return OccMetricsPaginators.this.client.listNamespaces(request);
            }
        }, (Function)new Function<ListNamespacesResponse, List<NamespaceSummary>>(){

            @Override
            public List<NamespaceSummary> apply(ListNamespacesResponse response) {
                return response.getNamespaceCollection().getItems();
            }
        });
    }
}

