/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocicontrolcenter.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ocicontrolcenter.model.DimensionValue;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizedMetricData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sampleTime")
    private final Date sampleTime;
    @JsonProperty(value="resolution")
    private final String resolution;
    @JsonProperty(value="dimensions")
    private final Map<String, DimensionValue> dimensions;
    @JsonProperty(value="aggregationMethod")
    private final String aggregationMethod;
    @JsonProperty(value="aggregatedValue")
    private final Float aggregatedValue;

    @Deprecated
    @ConstructorProperties(value={"sampleTime", "resolution", "dimensions", "aggregationMethod", "aggregatedValue"})
    public SummarizedMetricData(Date sampleTime, String resolution, Map<String, DimensionValue> dimensions, String aggregationMethod, Float aggregatedValue) {
        this.sampleTime = sampleTime;
        this.resolution = resolution;
        this.dimensions = dimensions;
        this.aggregationMethod = aggregationMethod;
        this.aggregatedValue = aggregatedValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getSampleTime() {
        return this.sampleTime;
    }

    public String getResolution() {
        return this.resolution;
    }

    public Map<String, DimensionValue> getDimensions() {
        return this.dimensions;
    }

    public String getAggregationMethod() {
        return this.aggregationMethod;
    }

    public Float getAggregatedValue() {
        return this.aggregatedValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizedMetricData(");
        sb.append("super=").append(super.toString());
        sb.append("sampleTime=").append(String.valueOf(this.sampleTime));
        sb.append(", resolution=").append(String.valueOf(this.resolution));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", aggregationMethod=").append(String.valueOf(this.aggregationMethod));
        sb.append(", aggregatedValue=").append(String.valueOf(this.aggregatedValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizedMetricData)) {
            return false;
        }
        SummarizedMetricData other = (SummarizedMetricData)((Object)o);
        return Objects.equals(this.sampleTime, other.sampleTime) && Objects.equals(this.resolution, other.resolution) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.aggregationMethod, other.aggregationMethod) && Objects.equals(this.aggregatedValue, other.aggregatedValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sampleTime == null ? 43 : this.sampleTime.hashCode());
        result = result * 59 + (this.resolution == null ? 43 : this.resolution.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.aggregationMethod == null ? 43 : this.aggregationMethod.hashCode());
        result = result * 59 + (this.aggregatedValue == null ? 43 : this.aggregatedValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sampleTime")
        private Date sampleTime;
        @JsonProperty(value="resolution")
        private String resolution;
        @JsonProperty(value="dimensions")
        private Map<String, DimensionValue> dimensions;
        @JsonProperty(value="aggregationMethod")
        private String aggregationMethod;
        @JsonProperty(value="aggregatedValue")
        private Float aggregatedValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sampleTime(Date sampleTime) {
            this.sampleTime = sampleTime;
            this.__explicitlySet__.add("sampleTime");
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            this.__explicitlySet__.add("resolution");
            return this;
        }

        public Builder dimensions(Map<String, DimensionValue> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder aggregationMethod(String aggregationMethod) {
            this.aggregationMethod = aggregationMethod;
            this.__explicitlySet__.add("aggregationMethod");
            return this;
        }

        public Builder aggregatedValue(Float aggregatedValue) {
            this.aggregatedValue = aggregatedValue;
            this.__explicitlySet__.add("aggregatedValue");
            return this;
        }

        public SummarizedMetricData build() {
            SummarizedMetricData model = new SummarizedMetricData(this.sampleTime, this.resolution, this.dimensions, this.aggregationMethod, this.aggregatedValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizedMetricData model) {
            if (model.wasPropertyExplicitlySet("sampleTime")) {
                this.sampleTime(model.getSampleTime());
            }
            if (model.wasPropertyExplicitlySet("resolution")) {
                this.resolution(model.getResolution());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("aggregationMethod")) {
                this.aggregationMethod(model.getAggregationMethod());
            }
            if (model.wasPropertyExplicitlySet("aggregatedValue")) {
                this.aggregatedValue(model.getAggregatedValue());
            }
            return this;
        }
    }
}

