/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ocvp.Cluster;
import com.oracle.bmc.ocvp.model.ClusterSummary;
import com.oracle.bmc.ocvp.requests.ListClustersRequest;
import com.oracle.bmc.ocvp.responses.ListClustersResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ClusterPaginators {
    private final Cluster client;

    public ClusterPaginators(Cluster client) {
        this.client = client;
    }

    public Iterable<ListClustersResponse> listClustersResponseIterator(final ListClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListClustersRequest.Builder>(){

            @Override
            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListClustersResponse, String>(){

            @Override
            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            @Override
            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListClustersRequest, ListClustersResponse>(){

            @Override
            public ListClustersResponse apply(ListClustersRequest request) {
                return ClusterPaginators.this.client.listClusters(request);
            }
        });
    }

    public Iterable<ClusterSummary> listClustersRecordIterator(final ListClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListClustersRequest.Builder>(){

            @Override
            public ListClustersRequest.Builder get() {
                return ListClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListClustersResponse, String>(){

            @Override
            public String apply(ListClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListClustersRequest.Builder>, ListClustersRequest>(){

            @Override
            public ListClustersRequest apply(RequestBuilderAndToken<ListClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListClustersRequest, ListClustersResponse>(){

            @Override
            public ListClustersResponse apply(ListClustersRequest request) {
                return ClusterPaginators.this.client.listClusters(request);
            }
        }, (Function)new Function<ListClustersResponse, List<ClusterSummary>>(){

            @Override
            public List<ClusterSummary> apply(ListClustersResponse response) {
                return response.getClusterCollection().getItems();
            }
        });
    }
}

