/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ocvp.Sddc;
import com.oracle.bmc.ocvp.model.SddcSummary;
import com.oracle.bmc.ocvp.model.SupportedCommitmentSummary;
import com.oracle.bmc.ocvp.model.SupportedHostShapeSummary;
import com.oracle.bmc.ocvp.model.SupportedVmwareSoftwareVersionSummary;
import com.oracle.bmc.ocvp.requests.ListSddcsRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedCommitmentsRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedHostShapesRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedVmwareSoftwareVersionsRequest;
import com.oracle.bmc.ocvp.responses.ListSddcsResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedCommitmentsResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedHostShapesResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedVmwareSoftwareVersionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SddcPaginators {
    private final Sddc client;

    public SddcPaginators(Sddc client) {
        this.client = client;
    }

    public Iterable<ListSddcsResponse> listSddcsResponseIterator(final ListSddcsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSddcsRequest.Builder>(){

            @Override
            public ListSddcsRequest.Builder get() {
                return ListSddcsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSddcsResponse, String>(){

            @Override
            public String apply(ListSddcsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSddcsRequest.Builder>, ListSddcsRequest>(){

            @Override
            public ListSddcsRequest apply(RequestBuilderAndToken<ListSddcsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSddcsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSddcsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSddcsRequest, ListSddcsResponse>(){

            @Override
            public ListSddcsResponse apply(ListSddcsRequest request) {
                return SddcPaginators.this.client.listSddcs(request);
            }
        });
    }

    public Iterable<SddcSummary> listSddcsRecordIterator(final ListSddcsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSddcsRequest.Builder>(){

            @Override
            public ListSddcsRequest.Builder get() {
                return ListSddcsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSddcsResponse, String>(){

            @Override
            public String apply(ListSddcsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSddcsRequest.Builder>, ListSddcsRequest>(){

            @Override
            public ListSddcsRequest apply(RequestBuilderAndToken<ListSddcsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSddcsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSddcsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSddcsRequest, ListSddcsResponse>(){

            @Override
            public ListSddcsResponse apply(ListSddcsRequest request) {
                return SddcPaginators.this.client.listSddcs(request);
            }
        }, (Function)new Function<ListSddcsResponse, List<SddcSummary>>(){

            @Override
            public List<SddcSummary> apply(ListSddcsResponse response) {
                return response.getSddcCollection().getItems();
            }
        });
    }

    public Iterable<ListSupportedCommitmentsResponse> listSupportedCommitmentsResponseIterator(final ListSupportedCommitmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSupportedCommitmentsRequest.Builder>(){

            @Override
            public ListSupportedCommitmentsRequest.Builder get() {
                return ListSupportedCommitmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedCommitmentsResponse, String>(){

            @Override
            public String apply(ListSupportedCommitmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedCommitmentsRequest.Builder>, ListSupportedCommitmentsRequest>(){

            @Override
            public ListSupportedCommitmentsRequest apply(RequestBuilderAndToken<ListSupportedCommitmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSupportedCommitmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedCommitmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSupportedCommitmentsRequest, ListSupportedCommitmentsResponse>(){

            @Override
            public ListSupportedCommitmentsResponse apply(ListSupportedCommitmentsRequest request) {
                return SddcPaginators.this.client.listSupportedCommitments(request);
            }
        });
    }

    public Iterable<SupportedCommitmentSummary> listSupportedCommitmentsRecordIterator(final ListSupportedCommitmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSupportedCommitmentsRequest.Builder>(){

            @Override
            public ListSupportedCommitmentsRequest.Builder get() {
                return ListSupportedCommitmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedCommitmentsResponse, String>(){

            @Override
            public String apply(ListSupportedCommitmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedCommitmentsRequest.Builder>, ListSupportedCommitmentsRequest>(){

            @Override
            public ListSupportedCommitmentsRequest apply(RequestBuilderAndToken<ListSupportedCommitmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSupportedCommitmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedCommitmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSupportedCommitmentsRequest, ListSupportedCommitmentsResponse>(){

            @Override
            public ListSupportedCommitmentsResponse apply(ListSupportedCommitmentsRequest request) {
                return SddcPaginators.this.client.listSupportedCommitments(request);
            }
        }, (Function)new Function<ListSupportedCommitmentsResponse, List<SupportedCommitmentSummary>>(){

            @Override
            public List<SupportedCommitmentSummary> apply(ListSupportedCommitmentsResponse response) {
                return response.getSupportedCommitmentSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListSupportedHostShapesResponse> listSupportedHostShapesResponseIterator(final ListSupportedHostShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSupportedHostShapesRequest.Builder>(){

            @Override
            public ListSupportedHostShapesRequest.Builder get() {
                return ListSupportedHostShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedHostShapesResponse, String>(){

            @Override
            public String apply(ListSupportedHostShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedHostShapesRequest.Builder>, ListSupportedHostShapesRequest>(){

            @Override
            public ListSupportedHostShapesRequest apply(RequestBuilderAndToken<ListSupportedHostShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSupportedHostShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedHostShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSupportedHostShapesRequest, ListSupportedHostShapesResponse>(){

            @Override
            public ListSupportedHostShapesResponse apply(ListSupportedHostShapesRequest request) {
                return SddcPaginators.this.client.listSupportedHostShapes(request);
            }
        });
    }

    public Iterable<SupportedHostShapeSummary> listSupportedHostShapesRecordIterator(final ListSupportedHostShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSupportedHostShapesRequest.Builder>(){

            @Override
            public ListSupportedHostShapesRequest.Builder get() {
                return ListSupportedHostShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedHostShapesResponse, String>(){

            @Override
            public String apply(ListSupportedHostShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedHostShapesRequest.Builder>, ListSupportedHostShapesRequest>(){

            @Override
            public ListSupportedHostShapesRequest apply(RequestBuilderAndToken<ListSupportedHostShapesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSupportedHostShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedHostShapesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSupportedHostShapesRequest, ListSupportedHostShapesResponse>(){

            @Override
            public ListSupportedHostShapesResponse apply(ListSupportedHostShapesRequest request) {
                return SddcPaginators.this.client.listSupportedHostShapes(request);
            }
        }, (Function)new Function<ListSupportedHostShapesResponse, List<SupportedHostShapeSummary>>(){

            @Override
            public List<SupportedHostShapeSummary> apply(ListSupportedHostShapesResponse response) {
                return response.getSupportedHostShapeCollection().getItems();
            }
        });
    }

    public Iterable<ListSupportedVmwareSoftwareVersionsResponse> listSupportedVmwareSoftwareVersionsResponseIterator(final ListSupportedVmwareSoftwareVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSupportedVmwareSoftwareVersionsRequest.Builder>(){

            @Override
            public ListSupportedVmwareSoftwareVersionsRequest.Builder get() {
                return ListSupportedVmwareSoftwareVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsResponse, String>(){

            @Override
            public String apply(ListSupportedVmwareSoftwareVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder>, ListSupportedVmwareSoftwareVersionsRequest>(){

            @Override
            public ListSupportedVmwareSoftwareVersionsRequest apply(RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsRequest, ListSupportedVmwareSoftwareVersionsResponse>(){

            @Override
            public ListSupportedVmwareSoftwareVersionsResponse apply(ListSupportedVmwareSoftwareVersionsRequest request) {
                return SddcPaginators.this.client.listSupportedVmwareSoftwareVersions(request);
            }
        });
    }

    public Iterable<SupportedVmwareSoftwareVersionSummary> listSupportedVmwareSoftwareVersionsRecordIterator(final ListSupportedVmwareSoftwareVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSupportedVmwareSoftwareVersionsRequest.Builder>(){

            @Override
            public ListSupportedVmwareSoftwareVersionsRequest.Builder get() {
                return ListSupportedVmwareSoftwareVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsResponse, String>(){

            @Override
            public String apply(ListSupportedVmwareSoftwareVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder>, ListSupportedVmwareSoftwareVersionsRequest>(){

            @Override
            public ListSupportedVmwareSoftwareVersionsRequest apply(RequestBuilderAndToken<ListSupportedVmwareSoftwareVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSupportedVmwareSoftwareVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsRequest, ListSupportedVmwareSoftwareVersionsResponse>(){

            @Override
            public ListSupportedVmwareSoftwareVersionsResponse apply(ListSupportedVmwareSoftwareVersionsRequest request) {
                return SddcPaginators.this.client.listSupportedVmwareSoftwareVersions(request);
            }
        }, (Function)new Function<ListSupportedVmwareSoftwareVersionsResponse, List<SupportedVmwareSoftwareVersionSummary>>(){

            @Override
            public List<SupportedVmwareSoftwareVersionSummary> apply(ListSupportedVmwareSoftwareVersionsResponse response) {
                return response.getSupportedVmwareSoftwareVersionCollection().getItems();
            }
        });
    }
}

