/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ocvp.model.Commitment;
import com.oracle.bmc.ocvp.model.DatastoreInfo;
import com.oracle.bmc.ocvp.model.NetworkConfiguration;
import com.oracle.bmc.ocvp.model.VsphereTypes;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InitialClusterConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="vsphereType")
    private final VsphereTypes vsphereType;
    @JsonProperty(value="computeAvailabilityDomain")
    private final String computeAvailabilityDomain;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="instanceDisplayNamePrefix")
    private final String instanceDisplayNamePrefix;
    @JsonProperty(value="esxiHostsCount")
    private final Integer esxiHostsCount;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;
    @JsonProperty(value="initialCommitment")
    private final Commitment initialCommitment;
    @JsonProperty(value="workloadNetworkCidr")
    private final String workloadNetworkCidr;
    @JsonProperty(value="initialHostShapeName")
    private final String initialHostShapeName;
    @JsonProperty(value="initialHostOcpuCount")
    private final Float initialHostOcpuCount;
    @JsonProperty(value="isShieldedInstanceEnabled")
    private final Boolean isShieldedInstanceEnabled;
    @JsonProperty(value="capacityReservationId")
    private final String capacityReservationId;
    @JsonProperty(value="datastores")
    private final List<DatastoreInfo> datastores;

    @Deprecated
    @ConstructorProperties(value={"vsphereType", "computeAvailabilityDomain", "displayName", "instanceDisplayNamePrefix", "esxiHostsCount", "networkConfiguration", "initialCommitment", "workloadNetworkCidr", "initialHostShapeName", "initialHostOcpuCount", "isShieldedInstanceEnabled", "capacityReservationId", "datastores"})
    public InitialClusterConfiguration(VsphereTypes vsphereType, String computeAvailabilityDomain, String displayName, String instanceDisplayNamePrefix, Integer esxiHostsCount, NetworkConfiguration networkConfiguration, Commitment initialCommitment, String workloadNetworkCidr, String initialHostShapeName, Float initialHostOcpuCount, Boolean isShieldedInstanceEnabled, String capacityReservationId, List<DatastoreInfo> datastores) {
        this.vsphereType = vsphereType;
        this.computeAvailabilityDomain = computeAvailabilityDomain;
        this.displayName = displayName;
        this.instanceDisplayNamePrefix = instanceDisplayNamePrefix;
        this.esxiHostsCount = esxiHostsCount;
        this.networkConfiguration = networkConfiguration;
        this.initialCommitment = initialCommitment;
        this.workloadNetworkCidr = workloadNetworkCidr;
        this.initialHostShapeName = initialHostShapeName;
        this.initialHostOcpuCount = initialHostOcpuCount;
        this.isShieldedInstanceEnabled = isShieldedInstanceEnabled;
        this.capacityReservationId = capacityReservationId;
        this.datastores = datastores;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public VsphereTypes getVsphereType() {
        return this.vsphereType;
    }

    public String getComputeAvailabilityDomain() {
        return this.computeAvailabilityDomain;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getInstanceDisplayNamePrefix() {
        return this.instanceDisplayNamePrefix;
    }

    public Integer getEsxiHostsCount() {
        return this.esxiHostsCount;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public Commitment getInitialCommitment() {
        return this.initialCommitment;
    }

    public String getWorkloadNetworkCidr() {
        return this.workloadNetworkCidr;
    }

    public String getInitialHostShapeName() {
        return this.initialHostShapeName;
    }

    public Float getInitialHostOcpuCount() {
        return this.initialHostOcpuCount;
    }

    public Boolean getIsShieldedInstanceEnabled() {
        return this.isShieldedInstanceEnabled;
    }

    public String getCapacityReservationId() {
        return this.capacityReservationId;
    }

    public List<DatastoreInfo> getDatastores() {
        return this.datastores;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InitialClusterConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("vsphereType=").append(String.valueOf((Object)this.vsphereType));
        sb.append(", computeAvailabilityDomain=").append(String.valueOf(this.computeAvailabilityDomain));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", instanceDisplayNamePrefix=").append(String.valueOf(this.instanceDisplayNamePrefix));
        sb.append(", esxiHostsCount=").append(String.valueOf(this.esxiHostsCount));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(", initialCommitment=").append(String.valueOf((Object)this.initialCommitment));
        sb.append(", workloadNetworkCidr=").append(String.valueOf(this.workloadNetworkCidr));
        sb.append(", initialHostShapeName=").append(String.valueOf(this.initialHostShapeName));
        sb.append(", initialHostOcpuCount=").append(String.valueOf(this.initialHostOcpuCount));
        sb.append(", isShieldedInstanceEnabled=").append(String.valueOf(this.isShieldedInstanceEnabled));
        sb.append(", capacityReservationId=").append(String.valueOf(this.capacityReservationId));
        sb.append(", datastores=").append(String.valueOf(this.datastores));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitialClusterConfiguration)) {
            return false;
        }
        InitialClusterConfiguration other = (InitialClusterConfiguration)((Object)o);
        return Objects.equals((Object)this.vsphereType, (Object)other.vsphereType) && Objects.equals(this.computeAvailabilityDomain, other.computeAvailabilityDomain) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.instanceDisplayNamePrefix, other.instanceDisplayNamePrefix) && Objects.equals(this.esxiHostsCount, other.esxiHostsCount) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && Objects.equals((Object)this.initialCommitment, (Object)other.initialCommitment) && Objects.equals(this.workloadNetworkCidr, other.workloadNetworkCidr) && Objects.equals(this.initialHostShapeName, other.initialHostShapeName) && Objects.equals(this.initialHostOcpuCount, other.initialHostOcpuCount) && Objects.equals(this.isShieldedInstanceEnabled, other.isShieldedInstanceEnabled) && Objects.equals(this.capacityReservationId, other.capacityReservationId) && Objects.equals(this.datastores, other.datastores) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.vsphereType == null ? 43 : this.vsphereType.hashCode());
        result = result * 59 + (this.computeAvailabilityDomain == null ? 43 : this.computeAvailabilityDomain.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.instanceDisplayNamePrefix == null ? 43 : this.instanceDisplayNamePrefix.hashCode());
        result = result * 59 + (this.esxiHostsCount == null ? 43 : this.esxiHostsCount.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        result = result * 59 + (this.initialCommitment == null ? 43 : this.initialCommitment.hashCode());
        result = result * 59 + (this.workloadNetworkCidr == null ? 43 : this.workloadNetworkCidr.hashCode());
        result = result * 59 + (this.initialHostShapeName == null ? 43 : this.initialHostShapeName.hashCode());
        result = result * 59 + (this.initialHostOcpuCount == null ? 43 : this.initialHostOcpuCount.hashCode());
        result = result * 59 + (this.isShieldedInstanceEnabled == null ? 43 : this.isShieldedInstanceEnabled.hashCode());
        result = result * 59 + (this.capacityReservationId == null ? 43 : this.capacityReservationId.hashCode());
        result = result * 59 + (this.datastores == null ? 43 : this.datastores.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vsphereType")
        private VsphereTypes vsphereType;
        @JsonProperty(value="computeAvailabilityDomain")
        private String computeAvailabilityDomain;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="instanceDisplayNamePrefix")
        private String instanceDisplayNamePrefix;
        @JsonProperty(value="esxiHostsCount")
        private Integer esxiHostsCount;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonProperty(value="initialCommitment")
        private Commitment initialCommitment;
        @JsonProperty(value="workloadNetworkCidr")
        private String workloadNetworkCidr;
        @JsonProperty(value="initialHostShapeName")
        private String initialHostShapeName;
        @JsonProperty(value="initialHostOcpuCount")
        private Float initialHostOcpuCount;
        @JsonProperty(value="isShieldedInstanceEnabled")
        private Boolean isShieldedInstanceEnabled;
        @JsonProperty(value="capacityReservationId")
        private String capacityReservationId;
        @JsonProperty(value="datastores")
        private List<DatastoreInfo> datastores;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vsphereType(VsphereTypes vsphereType) {
            this.vsphereType = vsphereType;
            this.__explicitlySet__.add("vsphereType");
            return this;
        }

        public Builder computeAvailabilityDomain(String computeAvailabilityDomain) {
            this.computeAvailabilityDomain = computeAvailabilityDomain;
            this.__explicitlySet__.add("computeAvailabilityDomain");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder instanceDisplayNamePrefix(String instanceDisplayNamePrefix) {
            this.instanceDisplayNamePrefix = instanceDisplayNamePrefix;
            this.__explicitlySet__.add("instanceDisplayNamePrefix");
            return this;
        }

        public Builder esxiHostsCount(Integer esxiHostsCount) {
            this.esxiHostsCount = esxiHostsCount;
            this.__explicitlySet__.add("esxiHostsCount");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public Builder initialCommitment(Commitment initialCommitment) {
            this.initialCommitment = initialCommitment;
            this.__explicitlySet__.add("initialCommitment");
            return this;
        }

        public Builder workloadNetworkCidr(String workloadNetworkCidr) {
            this.workloadNetworkCidr = workloadNetworkCidr;
            this.__explicitlySet__.add("workloadNetworkCidr");
            return this;
        }

        public Builder initialHostShapeName(String initialHostShapeName) {
            this.initialHostShapeName = initialHostShapeName;
            this.__explicitlySet__.add("initialHostShapeName");
            return this;
        }

        public Builder initialHostOcpuCount(Float initialHostOcpuCount) {
            this.initialHostOcpuCount = initialHostOcpuCount;
            this.__explicitlySet__.add("initialHostOcpuCount");
            return this;
        }

        public Builder isShieldedInstanceEnabled(Boolean isShieldedInstanceEnabled) {
            this.isShieldedInstanceEnabled = isShieldedInstanceEnabled;
            this.__explicitlySet__.add("isShieldedInstanceEnabled");
            return this;
        }

        public Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            this.__explicitlySet__.add("capacityReservationId");
            return this;
        }

        public Builder datastores(List<DatastoreInfo> datastores) {
            this.datastores = datastores;
            this.__explicitlySet__.add("datastores");
            return this;
        }

        public InitialClusterConfiguration build() {
            InitialClusterConfiguration model = new InitialClusterConfiguration(this.vsphereType, this.computeAvailabilityDomain, this.displayName, this.instanceDisplayNamePrefix, this.esxiHostsCount, this.networkConfiguration, this.initialCommitment, this.workloadNetworkCidr, this.initialHostShapeName, this.initialHostOcpuCount, this.isShieldedInstanceEnabled, this.capacityReservationId, this.datastores);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InitialClusterConfiguration model) {
            if (model.wasPropertyExplicitlySet("vsphereType")) {
                this.vsphereType(model.getVsphereType());
            }
            if (model.wasPropertyExplicitlySet("computeAvailabilityDomain")) {
                this.computeAvailabilityDomain(model.getComputeAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("instanceDisplayNamePrefix")) {
                this.instanceDisplayNamePrefix(model.getInstanceDisplayNamePrefix());
            }
            if (model.wasPropertyExplicitlySet("esxiHostsCount")) {
                this.esxiHostsCount(model.getEsxiHostsCount());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            if (model.wasPropertyExplicitlySet("initialCommitment")) {
                this.initialCommitment(model.getInitialCommitment());
            }
            if (model.wasPropertyExplicitlySet("workloadNetworkCidr")) {
                this.workloadNetworkCidr(model.getWorkloadNetworkCidr());
            }
            if (model.wasPropertyExplicitlySet("initialHostShapeName")) {
                this.initialHostShapeName(model.getInitialHostShapeName());
            }
            if (model.wasPropertyExplicitlySet("initialHostOcpuCount")) {
                this.initialHostOcpuCount(model.getInitialHostOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("isShieldedInstanceEnabled")) {
                this.isShieldedInstanceEnabled(model.getIsShieldedInstanceEnabled());
            }
            if (model.wasPropertyExplicitlySet("capacityReservationId")) {
                this.capacityReservationId(model.getCapacityReservationId());
            }
            if (model.wasPropertyExplicitlySet("datastores")) {
                this.datastores(model.getDatastores());
            }
            return this;
        }
    }
}

