/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SwapBillingRequest
extends BmcRequest<Void> {
    private String esxiHostId;
    private String swapBillingHostId;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getEsxiHostId() {
        return this.esxiHostId;
    }

    public String getSwapBillingHostId() {
        return this.swapBillingHostId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().esxiHostId(this.esxiHostId).swapBillingHostId(this.swapBillingHostId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",esxiHostId=").append(String.valueOf(this.esxiHostId));
        sb.append(",swapBillingHostId=").append(String.valueOf(this.swapBillingHostId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SwapBillingRequest)) {
            return false;
        }
        SwapBillingRequest other = (SwapBillingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.esxiHostId, other.esxiHostId) && Objects.equals(this.swapBillingHostId, other.swapBillingHostId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.esxiHostId == null ? 43 : this.esxiHostId.hashCode());
        result = result * 59 + (this.swapBillingHostId == null ? 43 : this.swapBillingHostId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SwapBillingRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String esxiHostId = null;
        private String swapBillingHostId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder esxiHostId(String esxiHostId) {
            this.esxiHostId = esxiHostId;
            return this;
        }

        public Builder swapBillingHostId(String swapBillingHostId) {
            this.swapBillingHostId = swapBillingHostId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SwapBillingRequest o) {
            this.esxiHostId(o.getEsxiHostId());
            this.swapBillingHostId(o.getSwapBillingHostId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SwapBillingRequest build() {
            SwapBillingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SwapBillingRequest buildWithoutInvocationCallback() {
            SwapBillingRequest request = new SwapBillingRequest();
            request.esxiHostId = this.esxiHostId;
            request.swapBillingHostId = this.swapBillingHostId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

