/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.ocvp.ClusterAsync;
import com.oracle.bmc.ocvp.model.Cluster;
import com.oracle.bmc.ocvp.model.ClusterCollection;
import com.oracle.bmc.ocvp.requests.CreateClusterRequest;
import com.oracle.bmc.ocvp.requests.DeleteClusterRequest;
import com.oracle.bmc.ocvp.requests.GetClusterRequest;
import com.oracle.bmc.ocvp.requests.ListClustersRequest;
import com.oracle.bmc.ocvp.requests.UpdateClusterRequest;
import com.oracle.bmc.ocvp.responses.CreateClusterResponse;
import com.oracle.bmc.ocvp.responses.DeleteClusterResponse;
import com.oracle.bmc.ocvp.responses.GetClusterResponse;
import com.oracle.bmc.ocvp.responses.ListClustersResponse;
import com.oracle.bmc.ocvp.responses.UpdateClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAsyncClient
extends BaseAsyncClient
implements ClusterAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://ocvps.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ClusterAsyncClient.class);

    ClusterAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateClusterResponse> createCluster(CreateClusterRequest request, AsyncHandler<CreateClusterRequest, CreateClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateClusterDetails(), "createClusterDetails is required");
        return this.clientCall(request, CreateClusterResponse::builder).logger(LOG, "createCluster").serviceDetails("Cluster", "CreateCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/CreateCluster").method(Method.POST).requestBuilder(CreateClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteClusterResponse> deleteCluster(DeleteClusterRequest request, AsyncHandler<DeleteClusterRequest, DeleteClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteClusterResponse::builder).logger(LOG, "deleteCluster").serviceDetails("Cluster", "DeleteCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/DeleteCluster").method(Method.DELETE).requestBuilder(DeleteClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterResponse> getCluster(GetClusterRequest request, AsyncHandler<GetClusterRequest, GetClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterResponse::builder).logger(LOG, "getCluster").serviceDetails("Cluster", "GetCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/GetCluster").method(Method.GET).requestBuilder(GetClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Cluster.class, GetClusterResponse.Builder::cluster).handleResponseHeaderString("etag", GetClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListClustersResponse> listClusters(ListClustersRequest request, AsyncHandler<ListClustersRequest, ListClustersResponse> handler) {
        return this.clientCall(request, ListClustersResponse::builder).logger(LOG, "listClusters").serviceDetails("Cluster", "ListClusters", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/ClusterSummary/ListClusters").method(Method.GET).requestBuilder(ListClustersRequest::builder).basePath("/20230701").appendPathParam("clusters").appendQueryParam("sddcId", (Object)request.getSddcId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterCollection.class, ListClustersResponse.Builder::clusterCollection).handleResponseHeaderString("opc-request-id", ListClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListClustersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateClusterResponse> updateCluster(UpdateClusterRequest request, AsyncHandler<UpdateClusterRequest, UpdateClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterDetails(), "updateClusterDetails is required");
        return this.clientCall(request, UpdateClusterResponse::builder).logger(LOG, "updateCluster").serviceDetails("Cluster", "UpdateCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/UpdateCluster").method(Method.PUT).requestBuilder(UpdateClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Cluster.class, UpdateClusterResponse.Builder::cluster).handleResponseHeaderString("etag", UpdateClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ClusterAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ClusterAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ClusterAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "ocvp";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ocvp");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ClusterAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ClusterAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

