/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.ocvp.Cluster;
import com.oracle.bmc.ocvp.ClusterPaginators;
import com.oracle.bmc.ocvp.ClusterWaiters;
import com.oracle.bmc.ocvp.model.ClusterCollection;
import com.oracle.bmc.ocvp.requests.CreateClusterRequest;
import com.oracle.bmc.ocvp.requests.DeleteClusterRequest;
import com.oracle.bmc.ocvp.requests.GetClusterRequest;
import com.oracle.bmc.ocvp.requests.ListClustersRequest;
import com.oracle.bmc.ocvp.requests.UpdateClusterRequest;
import com.oracle.bmc.ocvp.responses.CreateClusterResponse;
import com.oracle.bmc.ocvp.responses.DeleteClusterResponse;
import com.oracle.bmc.ocvp.responses.GetClusterResponse;
import com.oracle.bmc.ocvp.responses.ListClustersResponse;
import com.oracle.bmc.ocvp.responses.UpdateClusterResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterClient
extends BaseSyncClient
implements Cluster {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://ocvps.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ClusterClient.class);
    private final ClusterWaiters waiters;
    private final ClusterPaginators paginators;

    ClusterClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Cluster-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ClusterWaiters(executorService, this);
        this.paginators = new ClusterPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest request) {
        Objects.requireNonNull(request.getCreateClusterDetails(), "createClusterDetails is required");
        return (CreateClusterResponse)this.clientCall(request, CreateClusterResponse::builder).logger(LOG, "createCluster").serviceDetails("Cluster", "CreateCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/CreateCluster").method(Method.POST).requestBuilder(CreateClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return (DeleteClusterResponse)this.clientCall(request, DeleteClusterResponse::builder).logger(LOG, "deleteCluster").serviceDetails("Cluster", "DeleteCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/DeleteCluster").method(Method.DELETE).requestBuilder(DeleteClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetClusterResponse getCluster(GetClusterRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return (GetClusterResponse)this.clientCall(request, GetClusterResponse::builder).logger(LOG, "getCluster").serviceDetails("Cluster", "GetCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/GetCluster").method(Method.GET).requestBuilder(GetClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.ocvp.model.Cluster.class, GetClusterResponse.Builder::cluster).handleResponseHeaderString("etag", GetClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListClustersResponse listClusters(ListClustersRequest request) {
        return (ListClustersResponse)this.clientCall(request, ListClustersResponse::builder).logger(LOG, "listClusters").serviceDetails("Cluster", "ListClusters", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/ClusterSummary/ListClusters").method(Method.GET).requestBuilder(ListClustersRequest::builder).basePath("/20230701").appendPathParam("clusters").appendQueryParam("sddcId", (Object)request.getSddcId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ClusterCollection.class, ListClustersResponse.Builder::clusterCollection).handleResponseHeaderString("opc-request-id", ListClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListClustersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest request) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterDetails(), "updateClusterDetails is required");
        return (UpdateClusterResponse)this.clientCall(request, UpdateClusterResponse::builder).logger(LOG, "updateCluster").serviceDetails("Cluster", "UpdateCluster", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Cluster/UpdateCluster").method(Method.PUT).requestBuilder(UpdateClusterRequest::builder).basePath("/20230701").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.ocvp.model.Cluster.class, UpdateClusterResponse.Builder::cluster).handleResponseHeaderString("etag", UpdateClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ClusterWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ClusterPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ClusterClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ClusterClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ClusterClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ClusterClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ClusterClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ClusterClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "ocvp";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ocvp");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ClusterClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ClusterClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

