/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.ocvp.SddcAsync;
import com.oracle.bmc.ocvp.model.Sddc;
import com.oracle.bmc.ocvp.model.SddcCollection;
import com.oracle.bmc.ocvp.model.SddcPassword;
import com.oracle.bmc.ocvp.model.SupportedCommitmentSummaryCollection;
import com.oracle.bmc.ocvp.model.SupportedHostShapeCollection;
import com.oracle.bmc.ocvp.model.SupportedVmwareSoftwareVersionCollection;
import com.oracle.bmc.ocvp.requests.CancelDowngradeHcxRequest;
import com.oracle.bmc.ocvp.requests.ChangeSddcCompartmentRequest;
import com.oracle.bmc.ocvp.requests.CreateSddcRequest;
import com.oracle.bmc.ocvp.requests.DeleteSddcRequest;
import com.oracle.bmc.ocvp.requests.DowngradeHcxRequest;
import com.oracle.bmc.ocvp.requests.GetSddcRequest;
import com.oracle.bmc.ocvp.requests.ListSddcsRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedCommitmentsRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedHostShapesRequest;
import com.oracle.bmc.ocvp.requests.ListSupportedVmwareSoftwareVersionsRequest;
import com.oracle.bmc.ocvp.requests.RefreshHcxLicenseStatusRequest;
import com.oracle.bmc.ocvp.requests.RetrievePasswordRequest;
import com.oracle.bmc.ocvp.requests.UpdateSddcRequest;
import com.oracle.bmc.ocvp.requests.UpgradeHcxRequest;
import com.oracle.bmc.ocvp.responses.CancelDowngradeHcxResponse;
import com.oracle.bmc.ocvp.responses.ChangeSddcCompartmentResponse;
import com.oracle.bmc.ocvp.responses.CreateSddcResponse;
import com.oracle.bmc.ocvp.responses.DeleteSddcResponse;
import com.oracle.bmc.ocvp.responses.DowngradeHcxResponse;
import com.oracle.bmc.ocvp.responses.GetSddcResponse;
import com.oracle.bmc.ocvp.responses.ListSddcsResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedCommitmentsResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedHostShapesResponse;
import com.oracle.bmc.ocvp.responses.ListSupportedVmwareSoftwareVersionsResponse;
import com.oracle.bmc.ocvp.responses.RefreshHcxLicenseStatusResponse;
import com.oracle.bmc.ocvp.responses.RetrievePasswordResponse;
import com.oracle.bmc.ocvp.responses.UpdateSddcResponse;
import com.oracle.bmc.ocvp.responses.UpgradeHcxResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SddcAsyncClient
extends BaseAsyncClient
implements SddcAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SDDC").serviceEndpointPrefix("").serviceEndpointTemplate("https://ocvps.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SddcAsyncClient.class);

    SddcAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelDowngradeHcxResponse> cancelDowngradeHcx(CancelDowngradeHcxRequest request, AsyncHandler<CancelDowngradeHcxRequest, CancelDowngradeHcxResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelDowngradeHcxResponse::builder).logger(LOG, "cancelDowngradeHcx").serviceDetails("Sddc", "CancelDowngradeHcx", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/CancelDowngradeHcx").method(Method.POST).requestBuilder(CancelDowngradeHcxRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("cancelDowngradeHcx").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", CancelDowngradeHcxResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CancelDowngradeHcxResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeSddcCompartmentResponse> changeSddcCompartment(ChangeSddcCompartmentRequest request, AsyncHandler<ChangeSddcCompartmentRequest, ChangeSddcCompartmentResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSddcCompartmentDetails(), "changeSddcCompartmentDetails is required");
        return this.clientCall(request, ChangeSddcCompartmentResponse::builder).logger(LOG, "changeSddcCompartment").serviceDetails("Sddc", "ChangeSddcCompartment", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/ChangeSddcCompartment").method(Method.POST).requestBuilder(ChangeSddcCompartmentRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSddcCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSddcResponse> createSddc(CreateSddcRequest request, AsyncHandler<CreateSddcRequest, CreateSddcResponse> handler) {
        Objects.requireNonNull(request.getCreateSddcDetails(), "createSddcDetails is required");
        return this.clientCall(request, CreateSddcResponse::builder).logger(LOG, "createSddc").serviceDetails("Sddc", "CreateSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/CreateSddc").method(Method.POST).requestBuilder(CreateSddcRequest::builder).basePath("/20230701").appendPathParam("sddcs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateSddcResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSddcResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteSddcResponse> deleteSddc(DeleteSddcRequest request, AsyncHandler<DeleteSddcRequest, DeleteSddcResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSddcResponse::builder).logger(LOG, "deleteSddc").serviceDetails("Sddc", "DeleteSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/DeleteSddc").method(Method.DELETE).requestBuilder(DeleteSddcRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteSddcResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSddcResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DowngradeHcxResponse> downgradeHcx(DowngradeHcxRequest request, AsyncHandler<DowngradeHcxRequest, DowngradeHcxResponse> handler) {
        Objects.requireNonNull(request.getDowngradeHcxDetails(), "downgradeHcxDetails is required");
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DowngradeHcxResponse::builder).logger(LOG, "downgradeHcx").serviceDetails("Sddc", "DowngradeHcx", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/DowngradeHcx").method(Method.POST).requestBuilder(DowngradeHcxRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("downgradeHcx").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", DowngradeHcxResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DowngradeHcxResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSddcResponse> getSddc(GetSddcRequest request, AsyncHandler<GetSddcRequest, GetSddcResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSddcResponse::builder).logger(LOG, "getSddc").serviceDetails("Sddc", "GetSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/GetSddc").method(Method.GET).requestBuilder(GetSddcRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Sddc.class, GetSddcResponse.Builder::sddc).handleResponseHeaderString("etag", GetSddcResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSddcResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSddcsResponse> listSddcs(ListSddcsRequest request, AsyncHandler<ListSddcsRequest, ListSddcsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSddcsResponse::builder).logger(LOG, "listSddcs").serviceDetails("Sddc", "ListSddcs", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/SddcSummary/ListSddcs").method(Method.GET).requestBuilder(ListSddcsRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("computeAvailabilityDomain", (Object)request.getComputeAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SddcCollection.class, ListSddcsResponse.Builder::sddcCollection).handleResponseHeaderString("opc-request-id", ListSddcsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSddcsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSupportedCommitmentsResponse> listSupportedCommitments(ListSupportedCommitmentsRequest request, AsyncHandler<ListSupportedCommitmentsRequest, ListSupportedCommitmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSupportedCommitmentsResponse::builder).logger(LOG, "listSupportedCommitments").serviceDetails("Sddc", "ListSupportedCommitments", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/SupportedCommitmentSummary/ListSupportedCommitments").method(Method.GET).requestBuilder(ListSupportedCommitmentsRequest::builder).basePath("/20230701").appendPathParam("supportedCommitments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("hostShapeName", (Object)request.getHostShapeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SupportedCommitmentSummaryCollection.class, ListSupportedCommitmentsResponse.Builder::supportedCommitmentSummaryCollection).handleResponseHeaderString("opc-request-id", ListSupportedCommitmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedCommitmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSupportedHostShapesResponse> listSupportedHostShapes(ListSupportedHostShapesRequest request, AsyncHandler<ListSupportedHostShapesRequest, ListSupportedHostShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSupportedHostShapesResponse::builder).logger(LOG, "listSupportedHostShapes").serviceDetails("Sddc", "ListSupportedHostShapes", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/SupportedHostShapeSummary/ListSupportedHostShapes").method(Method.GET).requestBuilder(ListSupportedHostShapesRequest::builder).basePath("/20230701").appendPathParam("supportedHostShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("isSingleHostSddcSupported", (Object)request.getIsSingleHostSddcSupported()).appendQueryParam("initialHostShapeName", (Object)request.getInitialHostShapeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SupportedHostShapeCollection.class, ListSupportedHostShapesResponse.Builder::supportedHostShapeCollection).handleResponseHeaderString("opc-request-id", ListSupportedHostShapesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedHostShapesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSupportedVmwareSoftwareVersionsResponse> listSupportedVmwareSoftwareVersions(ListSupportedVmwareSoftwareVersionsRequest request, AsyncHandler<ListSupportedVmwareSoftwareVersionsRequest, ListSupportedVmwareSoftwareVersionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSupportedVmwareSoftwareVersionsResponse::builder).logger(LOG, "listSupportedVmwareSoftwareVersions").serviceDetails("Sddc", "ListSupportedVmwareSoftwareVersions", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions").method(Method.GET).requestBuilder(ListSupportedVmwareSoftwareVersionsRequest::builder).basePath("/20230701").appendPathParam("supportedVmwareSoftwareVersions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("version", (Object)request.getVersion()).appendQueryParam("hostShapeName", (Object)request.getHostShapeName()).appendQueryParam("versionToUpgrade", (Object)request.getVersionToUpgrade()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SupportedVmwareSoftwareVersionCollection.class, ListSupportedVmwareSoftwareVersionsResponse.Builder::supportedVmwareSoftwareVersionCollection).handleResponseHeaderString("opc-request-id", ListSupportedVmwareSoftwareVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSupportedVmwareSoftwareVersionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RefreshHcxLicenseStatusResponse> refreshHcxLicenseStatus(RefreshHcxLicenseStatusRequest request, AsyncHandler<RefreshHcxLicenseStatusRequest, RefreshHcxLicenseStatusResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RefreshHcxLicenseStatusResponse::builder).logger(LOG, "refreshHcxLicenseStatus").serviceDetails("Sddc", "RefreshHcxLicenseStatus", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/RefreshHcxLicenseStatus").method(Method.POST).requestBuilder(RefreshHcxLicenseStatusRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("refreshHcxLicenses").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", RefreshHcxLicenseStatusResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RefreshHcxLicenseStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RetrievePasswordResponse> retrievePassword(RetrievePasswordRequest request, AsyncHandler<RetrievePasswordRequest, RetrievePasswordResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getType(), "type is required");
        return this.clientCall(request, RetrievePasswordResponse::builder).logger(LOG, "retrievePassword").serviceDetails("Sddc", "RetrievePassword", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/RetrievePassword").method(Method.POST).requestBuilder(RetrievePasswordRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("retrievePassword").appendEnumQueryParam("type", (BmcEnum)request.getType()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(SddcPassword.class, RetrievePasswordResponse.Builder::sddcPassword).handleResponseHeaderString("etag", RetrievePasswordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RetrievePasswordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSddcResponse> updateSddc(UpdateSddcRequest request, AsyncHandler<UpdateSddcRequest, UpdateSddcResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSddcDetails(), "updateSddcDetails is required");
        return this.clientCall(request, UpdateSddcResponse::builder).logger(LOG, "updateSddc").serviceDetails("Sddc", "UpdateSddc", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc").method(Method.PUT).requestBuilder(UpdateSddcRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Sddc.class, UpdateSddcResponse.Builder::sddc).handleResponseHeaderString("etag", UpdateSddcResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSddcResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpgradeHcxResponse> upgradeHcx(UpgradeHcxRequest request, AsyncHandler<UpgradeHcxRequest, UpgradeHcxResponse> handler) {
        Validate.notBlank((String)request.getSddcId(), (String)"sddcId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpgradeHcxResponse::builder).logger(LOG, "upgradeHcx").serviceDetails("Sddc", "UpgradeHcx", "https://docs.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpgradeHcx").method(Method.POST).requestBuilder(UpgradeHcxRequest::builder).basePath("/20230701").appendPathParam("sddcs").appendPathParam(request.getSddcId()).appendPathParam("actions").appendPathParam("upgradeHcx").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", UpgradeHcxResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeHcxResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public SddcAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SddcAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SddcAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SddcAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SddcAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SddcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SddcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SddcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SddcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SddcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SddcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SddcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SddcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SddcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SddcAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "ocvp";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ocvp");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SddcAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SddcAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

