/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ocvp.model.Commitment;
import com.oracle.bmc.ocvp.model.DatastoreDetails;
import com.oracle.bmc.ocvp.model.LifecycleStates;
import com.oracle.bmc.ocvp.model.NetworkConfiguration;
import com.oracle.bmc.ocvp.model.VsphereLicense;
import com.oracle.bmc.ocvp.model.VsphereTypes;
import com.oracle.bmc.ocvp.model.VsphereUpgradeObject;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Cluster
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="computeAvailabilityDomain")
    private final String computeAvailabilityDomain;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="instanceDisplayNamePrefix")
    private final String instanceDisplayNamePrefix;
    @JsonProperty(value="vmwareSoftwareVersion")
    private final String vmwareSoftwareVersion;
    @JsonProperty(value="esxiSoftwareVersion")
    private final String esxiSoftwareVersion;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="sddcId")
    private final String sddcId;
    @JsonProperty(value="esxiHostsCount")
    private final Integer esxiHostsCount;
    @JsonProperty(value="initialCommitment")
    private final Commitment initialCommitment;
    @JsonProperty(value="workloadNetworkCidr")
    private final String workloadNetworkCidr;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleStates lifecycleState;
    @JsonProperty(value="upgradeLicenses")
    private final List<VsphereLicense> upgradeLicenses;
    @JsonProperty(value="vsphereUpgradeObjects")
    private final List<VsphereUpgradeObject> vsphereUpgradeObjects;
    @JsonProperty(value="initialHostShapeName")
    private final String initialHostShapeName;
    @JsonProperty(value="initialHostOcpuCount")
    private final Float initialHostOcpuCount;
    @JsonProperty(value="isShieldedInstanceEnabled")
    private final Boolean isShieldedInstanceEnabled;
    @JsonProperty(value="capacityReservationId")
    private final String capacityReservationId;
    @JsonProperty(value="datastores")
    private final List<DatastoreDetails> datastores;
    @JsonProperty(value="vsphereType")
    private final VsphereTypes vsphereType;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "computeAvailabilityDomain", "displayName", "instanceDisplayNamePrefix", "vmwareSoftwareVersion", "esxiSoftwareVersion", "compartmentId", "sddcId", "esxiHostsCount", "initialCommitment", "workloadNetworkCidr", "networkConfiguration", "timeCreated", "timeUpdated", "lifecycleState", "upgradeLicenses", "vsphereUpgradeObjects", "initialHostShapeName", "initialHostOcpuCount", "isShieldedInstanceEnabled", "capacityReservationId", "datastores", "vsphereType", "freeformTags", "definedTags", "systemTags"})
    public Cluster(String id, String computeAvailabilityDomain, String displayName, String instanceDisplayNamePrefix, String vmwareSoftwareVersion, String esxiSoftwareVersion, String compartmentId, String sddcId, Integer esxiHostsCount, Commitment initialCommitment, String workloadNetworkCidr, NetworkConfiguration networkConfiguration, Date timeCreated, Date timeUpdated, LifecycleStates lifecycleState, List<VsphereLicense> upgradeLicenses, List<VsphereUpgradeObject> vsphereUpgradeObjects, String initialHostShapeName, Float initialHostOcpuCount, Boolean isShieldedInstanceEnabled, String capacityReservationId, List<DatastoreDetails> datastores, VsphereTypes vsphereType, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.computeAvailabilityDomain = computeAvailabilityDomain;
        this.displayName = displayName;
        this.instanceDisplayNamePrefix = instanceDisplayNamePrefix;
        this.vmwareSoftwareVersion = vmwareSoftwareVersion;
        this.esxiSoftwareVersion = esxiSoftwareVersion;
        this.compartmentId = compartmentId;
        this.sddcId = sddcId;
        this.esxiHostsCount = esxiHostsCount;
        this.initialCommitment = initialCommitment;
        this.workloadNetworkCidr = workloadNetworkCidr;
        this.networkConfiguration = networkConfiguration;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.upgradeLicenses = upgradeLicenses;
        this.vsphereUpgradeObjects = vsphereUpgradeObjects;
        this.initialHostShapeName = initialHostShapeName;
        this.initialHostOcpuCount = initialHostOcpuCount;
        this.isShieldedInstanceEnabled = isShieldedInstanceEnabled;
        this.capacityReservationId = capacityReservationId;
        this.datastores = datastores;
        this.vsphereType = vsphereType;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getComputeAvailabilityDomain() {
        return this.computeAvailabilityDomain;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getInstanceDisplayNamePrefix() {
        return this.instanceDisplayNamePrefix;
    }

    public String getVmwareSoftwareVersion() {
        return this.vmwareSoftwareVersion;
    }

    public String getEsxiSoftwareVersion() {
        return this.esxiSoftwareVersion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSddcId() {
        return this.sddcId;
    }

    public Integer getEsxiHostsCount() {
        return this.esxiHostsCount;
    }

    public Commitment getInitialCommitment() {
        return this.initialCommitment;
    }

    public String getWorkloadNetworkCidr() {
        return this.workloadNetworkCidr;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public List<VsphereLicense> getUpgradeLicenses() {
        return this.upgradeLicenses;
    }

    public List<VsphereUpgradeObject> getVsphereUpgradeObjects() {
        return this.vsphereUpgradeObjects;
    }

    public String getInitialHostShapeName() {
        return this.initialHostShapeName;
    }

    public Float getInitialHostOcpuCount() {
        return this.initialHostOcpuCount;
    }

    public Boolean getIsShieldedInstanceEnabled() {
        return this.isShieldedInstanceEnabled;
    }

    public String getCapacityReservationId() {
        return this.capacityReservationId;
    }

    public List<DatastoreDetails> getDatastores() {
        return this.datastores;
    }

    public VsphereTypes getVsphereType() {
        return this.vsphereType;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cluster(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", computeAvailabilityDomain=").append(String.valueOf(this.computeAvailabilityDomain));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", instanceDisplayNamePrefix=").append(String.valueOf(this.instanceDisplayNamePrefix));
        sb.append(", vmwareSoftwareVersion=").append(String.valueOf(this.vmwareSoftwareVersion));
        sb.append(", esxiSoftwareVersion=").append(String.valueOf(this.esxiSoftwareVersion));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", sddcId=").append(String.valueOf(this.sddcId));
        sb.append(", esxiHostsCount=").append(String.valueOf(this.esxiHostsCount));
        sb.append(", initialCommitment=").append(String.valueOf((Object)this.initialCommitment));
        sb.append(", workloadNetworkCidr=").append(String.valueOf(this.workloadNetworkCidr));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", upgradeLicenses=").append(String.valueOf(this.upgradeLicenses));
        sb.append(", vsphereUpgradeObjects=").append(String.valueOf(this.vsphereUpgradeObjects));
        sb.append(", initialHostShapeName=").append(String.valueOf(this.initialHostShapeName));
        sb.append(", initialHostOcpuCount=").append(String.valueOf(this.initialHostOcpuCount));
        sb.append(", isShieldedInstanceEnabled=").append(String.valueOf(this.isShieldedInstanceEnabled));
        sb.append(", capacityReservationId=").append(String.valueOf(this.capacityReservationId));
        sb.append(", datastores=").append(String.valueOf(this.datastores));
        sb.append(", vsphereType=").append(String.valueOf((Object)this.vsphereType));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.computeAvailabilityDomain, other.computeAvailabilityDomain) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.instanceDisplayNamePrefix, other.instanceDisplayNamePrefix) && Objects.equals(this.vmwareSoftwareVersion, other.vmwareSoftwareVersion) && Objects.equals(this.esxiSoftwareVersion, other.esxiSoftwareVersion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.sddcId, other.sddcId) && Objects.equals(this.esxiHostsCount, other.esxiHostsCount) && Objects.equals((Object)this.initialCommitment, (Object)other.initialCommitment) && Objects.equals(this.workloadNetworkCidr, other.workloadNetworkCidr) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.upgradeLicenses, other.upgradeLicenses) && Objects.equals(this.vsphereUpgradeObjects, other.vsphereUpgradeObjects) && Objects.equals(this.initialHostShapeName, other.initialHostShapeName) && Objects.equals(this.initialHostOcpuCount, other.initialHostOcpuCount) && Objects.equals(this.isShieldedInstanceEnabled, other.isShieldedInstanceEnabled) && Objects.equals(this.capacityReservationId, other.capacityReservationId) && Objects.equals(this.datastores, other.datastores) && Objects.equals((Object)this.vsphereType, (Object)other.vsphereType) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.computeAvailabilityDomain == null ? 43 : this.computeAvailabilityDomain.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.instanceDisplayNamePrefix == null ? 43 : this.instanceDisplayNamePrefix.hashCode());
        result = result * 59 + (this.vmwareSoftwareVersion == null ? 43 : this.vmwareSoftwareVersion.hashCode());
        result = result * 59 + (this.esxiSoftwareVersion == null ? 43 : this.esxiSoftwareVersion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sddcId == null ? 43 : this.sddcId.hashCode());
        result = result * 59 + (this.esxiHostsCount == null ? 43 : this.esxiHostsCount.hashCode());
        result = result * 59 + (this.initialCommitment == null ? 43 : this.initialCommitment.hashCode());
        result = result * 59 + (this.workloadNetworkCidr == null ? 43 : this.workloadNetworkCidr.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.upgradeLicenses == null ? 43 : this.upgradeLicenses.hashCode());
        result = result * 59 + (this.vsphereUpgradeObjects == null ? 43 : this.vsphereUpgradeObjects.hashCode());
        result = result * 59 + (this.initialHostShapeName == null ? 43 : this.initialHostShapeName.hashCode());
        result = result * 59 + (this.initialHostOcpuCount == null ? 43 : this.initialHostOcpuCount.hashCode());
        result = result * 59 + (this.isShieldedInstanceEnabled == null ? 43 : this.isShieldedInstanceEnabled.hashCode());
        result = result * 59 + (this.capacityReservationId == null ? 43 : this.capacityReservationId.hashCode());
        result = result * 59 + (this.datastores == null ? 43 : this.datastores.hashCode());
        result = result * 59 + (this.vsphereType == null ? 43 : this.vsphereType.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="computeAvailabilityDomain")
        private String computeAvailabilityDomain;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="instanceDisplayNamePrefix")
        private String instanceDisplayNamePrefix;
        @JsonProperty(value="vmwareSoftwareVersion")
        private String vmwareSoftwareVersion;
        @JsonProperty(value="esxiSoftwareVersion")
        private String esxiSoftwareVersion;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sddcId")
        private String sddcId;
        @JsonProperty(value="esxiHostsCount")
        private Integer esxiHostsCount;
        @JsonProperty(value="initialCommitment")
        private Commitment initialCommitment;
        @JsonProperty(value="workloadNetworkCidr")
        private String workloadNetworkCidr;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleStates lifecycleState;
        @JsonProperty(value="upgradeLicenses")
        private List<VsphereLicense> upgradeLicenses;
        @JsonProperty(value="vsphereUpgradeObjects")
        private List<VsphereUpgradeObject> vsphereUpgradeObjects;
        @JsonProperty(value="initialHostShapeName")
        private String initialHostShapeName;
        @JsonProperty(value="initialHostOcpuCount")
        private Float initialHostOcpuCount;
        @JsonProperty(value="isShieldedInstanceEnabled")
        private Boolean isShieldedInstanceEnabled;
        @JsonProperty(value="capacityReservationId")
        private String capacityReservationId;
        @JsonProperty(value="datastores")
        private List<DatastoreDetails> datastores;
        @JsonProperty(value="vsphereType")
        private VsphereTypes vsphereType;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder computeAvailabilityDomain(String computeAvailabilityDomain) {
            this.computeAvailabilityDomain = computeAvailabilityDomain;
            this.__explicitlySet__.add("computeAvailabilityDomain");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder instanceDisplayNamePrefix(String instanceDisplayNamePrefix) {
            this.instanceDisplayNamePrefix = instanceDisplayNamePrefix;
            this.__explicitlySet__.add("instanceDisplayNamePrefix");
            return this;
        }

        public Builder vmwareSoftwareVersion(String vmwareSoftwareVersion) {
            this.vmwareSoftwareVersion = vmwareSoftwareVersion;
            this.__explicitlySet__.add("vmwareSoftwareVersion");
            return this;
        }

        public Builder esxiSoftwareVersion(String esxiSoftwareVersion) {
            this.esxiSoftwareVersion = esxiSoftwareVersion;
            this.__explicitlySet__.add("esxiSoftwareVersion");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sddcId(String sddcId) {
            this.sddcId = sddcId;
            this.__explicitlySet__.add("sddcId");
            return this;
        }

        public Builder esxiHostsCount(Integer esxiHostsCount) {
            this.esxiHostsCount = esxiHostsCount;
            this.__explicitlySet__.add("esxiHostsCount");
            return this;
        }

        public Builder initialCommitment(Commitment initialCommitment) {
            this.initialCommitment = initialCommitment;
            this.__explicitlySet__.add("initialCommitment");
            return this;
        }

        public Builder workloadNetworkCidr(String workloadNetworkCidr) {
            this.workloadNetworkCidr = workloadNetworkCidr;
            this.__explicitlySet__.add("workloadNetworkCidr");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder upgradeLicenses(List<VsphereLicense> upgradeLicenses) {
            this.upgradeLicenses = upgradeLicenses;
            this.__explicitlySet__.add("upgradeLicenses");
            return this;
        }

        public Builder vsphereUpgradeObjects(List<VsphereUpgradeObject> vsphereUpgradeObjects) {
            this.vsphereUpgradeObjects = vsphereUpgradeObjects;
            this.__explicitlySet__.add("vsphereUpgradeObjects");
            return this;
        }

        public Builder initialHostShapeName(String initialHostShapeName) {
            this.initialHostShapeName = initialHostShapeName;
            this.__explicitlySet__.add("initialHostShapeName");
            return this;
        }

        public Builder initialHostOcpuCount(Float initialHostOcpuCount) {
            this.initialHostOcpuCount = initialHostOcpuCount;
            this.__explicitlySet__.add("initialHostOcpuCount");
            return this;
        }

        public Builder isShieldedInstanceEnabled(Boolean isShieldedInstanceEnabled) {
            this.isShieldedInstanceEnabled = isShieldedInstanceEnabled;
            this.__explicitlySet__.add("isShieldedInstanceEnabled");
            return this;
        }

        public Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            this.__explicitlySet__.add("capacityReservationId");
            return this;
        }

        public Builder datastores(List<DatastoreDetails> datastores) {
            this.datastores = datastores;
            this.__explicitlySet__.add("datastores");
            return this;
        }

        public Builder vsphereType(VsphereTypes vsphereType) {
            this.vsphereType = vsphereType;
            this.__explicitlySet__.add("vsphereType");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Cluster build() {
            Cluster model = new Cluster(this.id, this.computeAvailabilityDomain, this.displayName, this.instanceDisplayNamePrefix, this.vmwareSoftwareVersion, this.esxiSoftwareVersion, this.compartmentId, this.sddcId, this.esxiHostsCount, this.initialCommitment, this.workloadNetworkCidr, this.networkConfiguration, this.timeCreated, this.timeUpdated, this.lifecycleState, this.upgradeLicenses, this.vsphereUpgradeObjects, this.initialHostShapeName, this.initialHostOcpuCount, this.isShieldedInstanceEnabled, this.capacityReservationId, this.datastores, this.vsphereType, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Cluster model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("computeAvailabilityDomain")) {
                this.computeAvailabilityDomain(model.getComputeAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("instanceDisplayNamePrefix")) {
                this.instanceDisplayNamePrefix(model.getInstanceDisplayNamePrefix());
            }
            if (model.wasPropertyExplicitlySet("vmwareSoftwareVersion")) {
                this.vmwareSoftwareVersion(model.getVmwareSoftwareVersion());
            }
            if (model.wasPropertyExplicitlySet("esxiSoftwareVersion")) {
                this.esxiSoftwareVersion(model.getEsxiSoftwareVersion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sddcId")) {
                this.sddcId(model.getSddcId());
            }
            if (model.wasPropertyExplicitlySet("esxiHostsCount")) {
                this.esxiHostsCount(model.getEsxiHostsCount());
            }
            if (model.wasPropertyExplicitlySet("initialCommitment")) {
                this.initialCommitment(model.getInitialCommitment());
            }
            if (model.wasPropertyExplicitlySet("workloadNetworkCidr")) {
                this.workloadNetworkCidr(model.getWorkloadNetworkCidr());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("upgradeLicenses")) {
                this.upgradeLicenses(model.getUpgradeLicenses());
            }
            if (model.wasPropertyExplicitlySet("vsphereUpgradeObjects")) {
                this.vsphereUpgradeObjects(model.getVsphereUpgradeObjects());
            }
            if (model.wasPropertyExplicitlySet("initialHostShapeName")) {
                this.initialHostShapeName(model.getInitialHostShapeName());
            }
            if (model.wasPropertyExplicitlySet("initialHostOcpuCount")) {
                this.initialHostOcpuCount(model.getInitialHostOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("isShieldedInstanceEnabled")) {
                this.isShieldedInstanceEnabled(model.getIsShieldedInstanceEnabled());
            }
            if (model.wasPropertyExplicitlySet("capacityReservationId")) {
                this.capacityReservationId(model.getCapacityReservationId());
            }
            if (model.wasPropertyExplicitlySet("datastores")) {
                this.datastores(model.getDatastores());
            }
            if (model.wasPropertyExplicitlySet("vsphereType")) {
                this.vsphereType(model.getVsphereType());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

