/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SupportedEsxiSoftwareVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="supportedHostShapeNames")
    private final List<String> supportedHostShapeNames;

    @Deprecated
    @ConstructorProperties(value={"version", "description", "supportedHostShapeNames"})
    public SupportedEsxiSoftwareVersionSummary(String version, String description, List<String> supportedHostShapeNames) {
        this.version = version;
        this.description = description;
        this.supportedHostShapeNames = supportedHostShapeNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSupportedHostShapeNames() {
        return this.supportedHostShapeNames;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SupportedEsxiSoftwareVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", supportedHostShapeNames=").append(String.valueOf(this.supportedHostShapeNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SupportedEsxiSoftwareVersionSummary)) {
            return false;
        }
        SupportedEsxiSoftwareVersionSummary other = (SupportedEsxiSoftwareVersionSummary)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.description, other.description) && Objects.equals(this.supportedHostShapeNames, other.supportedHostShapeNames) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.supportedHostShapeNames == null ? 43 : this.supportedHostShapeNames.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="supportedHostShapeNames")
        private List<String> supportedHostShapeNames;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder supportedHostShapeNames(List<String> supportedHostShapeNames) {
            this.supportedHostShapeNames = supportedHostShapeNames;
            this.__explicitlySet__.add("supportedHostShapeNames");
            return this;
        }

        public SupportedEsxiSoftwareVersionSummary build() {
            SupportedEsxiSoftwareVersionSummary model = new SupportedEsxiSoftwareVersionSummary(this.version, this.description, this.supportedHostShapeNames);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SupportedEsxiSoftwareVersionSummary model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("supportedHostShapeNames")) {
                this.supportedHostShapeNames(model.getSupportedHostShapeNames());
            }
            return this;
        }
    }
}

