/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.ocvp.model.OperationTypes;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SupportedHostShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="supportedOperations")
    private final List<OperationTypes> supportedOperations;
    @JsonProperty(value="shapeFamily")
    private final String shapeFamily;
    @JsonProperty(value="defaultOcpuCount")
    private final Float defaultOcpuCount;
    @JsonProperty(value="supportedOcpuCount")
    private final List<Float> supportedOcpuCount;
    @JsonProperty(value="isSingleHostSddcSupported")
    private final Boolean isSingleHostSddcSupported;
    @JsonProperty(value="supportedVmwareSoftwareVersions")
    private final List<String> supportedVmwareSoftwareVersions;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isSupportShieldedInstances")
    private final Boolean isSupportShieldedInstances;
    @JsonProperty(value="isSupportMonthlyCommitment")
    private final Boolean isSupportMonthlyCommitment;

    @Deprecated
    @ConstructorProperties(value={"name", "supportedOperations", "shapeFamily", "defaultOcpuCount", "supportedOcpuCount", "isSingleHostSddcSupported", "supportedVmwareSoftwareVersions", "description", "isSupportShieldedInstances", "isSupportMonthlyCommitment"})
    public SupportedHostShapeSummary(String name, List<OperationTypes> supportedOperations, String shapeFamily, Float defaultOcpuCount, List<Float> supportedOcpuCount, Boolean isSingleHostSddcSupported, List<String> supportedVmwareSoftwareVersions, String description, Boolean isSupportShieldedInstances, Boolean isSupportMonthlyCommitment) {
        this.name = name;
        this.supportedOperations = supportedOperations;
        this.shapeFamily = shapeFamily;
        this.defaultOcpuCount = defaultOcpuCount;
        this.supportedOcpuCount = supportedOcpuCount;
        this.isSingleHostSddcSupported = isSingleHostSddcSupported;
        this.supportedVmwareSoftwareVersions = supportedVmwareSoftwareVersions;
        this.description = description;
        this.isSupportShieldedInstances = isSupportShieldedInstances;
        this.isSupportMonthlyCommitment = isSupportMonthlyCommitment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public List<OperationTypes> getSupportedOperations() {
        return this.supportedOperations;
    }

    public String getShapeFamily() {
        return this.shapeFamily;
    }

    public Float getDefaultOcpuCount() {
        return this.defaultOcpuCount;
    }

    public List<Float> getSupportedOcpuCount() {
        return this.supportedOcpuCount;
    }

    public Boolean getIsSingleHostSddcSupported() {
        return this.isSingleHostSddcSupported;
    }

    public List<String> getSupportedVmwareSoftwareVersions() {
        return this.supportedVmwareSoftwareVersions;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsSupportShieldedInstances() {
        return this.isSupportShieldedInstances;
    }

    public Boolean getIsSupportMonthlyCommitment() {
        return this.isSupportMonthlyCommitment;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SupportedHostShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", supportedOperations=").append(String.valueOf(this.supportedOperations));
        sb.append(", shapeFamily=").append(String.valueOf(this.shapeFamily));
        sb.append(", defaultOcpuCount=").append(String.valueOf(this.defaultOcpuCount));
        sb.append(", supportedOcpuCount=").append(String.valueOf(this.supportedOcpuCount));
        sb.append(", isSingleHostSddcSupported=").append(String.valueOf(this.isSingleHostSddcSupported));
        sb.append(", supportedVmwareSoftwareVersions=").append(String.valueOf(this.supportedVmwareSoftwareVersions));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isSupportShieldedInstances=").append(String.valueOf(this.isSupportShieldedInstances));
        sb.append(", isSupportMonthlyCommitment=").append(String.valueOf(this.isSupportMonthlyCommitment));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SupportedHostShapeSummary)) {
            return false;
        }
        SupportedHostShapeSummary other = (SupportedHostShapeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.supportedOperations, other.supportedOperations) && Objects.equals(this.shapeFamily, other.shapeFamily) && Objects.equals(this.defaultOcpuCount, other.defaultOcpuCount) && Objects.equals(this.supportedOcpuCount, other.supportedOcpuCount) && Objects.equals(this.isSingleHostSddcSupported, other.isSingleHostSddcSupported) && Objects.equals(this.supportedVmwareSoftwareVersions, other.supportedVmwareSoftwareVersions) && Objects.equals(this.description, other.description) && Objects.equals(this.isSupportShieldedInstances, other.isSupportShieldedInstances) && Objects.equals(this.isSupportMonthlyCommitment, other.isSupportMonthlyCommitment) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.supportedOperations == null ? 43 : this.supportedOperations.hashCode());
        result = result * 59 + (this.shapeFamily == null ? 43 : this.shapeFamily.hashCode());
        result = result * 59 + (this.defaultOcpuCount == null ? 43 : this.defaultOcpuCount.hashCode());
        result = result * 59 + (this.supportedOcpuCount == null ? 43 : this.supportedOcpuCount.hashCode());
        result = result * 59 + (this.isSingleHostSddcSupported == null ? 43 : this.isSingleHostSddcSupported.hashCode());
        result = result * 59 + (this.supportedVmwareSoftwareVersions == null ? 43 : this.supportedVmwareSoftwareVersions.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isSupportShieldedInstances == null ? 43 : this.isSupportShieldedInstances.hashCode());
        result = result * 59 + (this.isSupportMonthlyCommitment == null ? 43 : this.isSupportMonthlyCommitment.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="supportedOperations")
        private List<OperationTypes> supportedOperations;
        @JsonProperty(value="shapeFamily")
        private String shapeFamily;
        @JsonProperty(value="defaultOcpuCount")
        private Float defaultOcpuCount;
        @JsonProperty(value="supportedOcpuCount")
        private List<Float> supportedOcpuCount;
        @JsonProperty(value="isSingleHostSddcSupported")
        private Boolean isSingleHostSddcSupported;
        @JsonProperty(value="supportedVmwareSoftwareVersions")
        private List<String> supportedVmwareSoftwareVersions;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isSupportShieldedInstances")
        private Boolean isSupportShieldedInstances;
        @JsonProperty(value="isSupportMonthlyCommitment")
        private Boolean isSupportMonthlyCommitment;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder supportedOperations(List<OperationTypes> supportedOperations) {
            this.supportedOperations = supportedOperations;
            this.__explicitlySet__.add("supportedOperations");
            return this;
        }

        public Builder shapeFamily(String shapeFamily) {
            this.shapeFamily = shapeFamily;
            this.__explicitlySet__.add("shapeFamily");
            return this;
        }

        public Builder defaultOcpuCount(Float defaultOcpuCount) {
            this.defaultOcpuCount = defaultOcpuCount;
            this.__explicitlySet__.add("defaultOcpuCount");
            return this;
        }

        public Builder supportedOcpuCount(List<Float> supportedOcpuCount) {
            this.supportedOcpuCount = supportedOcpuCount;
            this.__explicitlySet__.add("supportedOcpuCount");
            return this;
        }

        public Builder isSingleHostSddcSupported(Boolean isSingleHostSddcSupported) {
            this.isSingleHostSddcSupported = isSingleHostSddcSupported;
            this.__explicitlySet__.add("isSingleHostSddcSupported");
            return this;
        }

        public Builder supportedVmwareSoftwareVersions(List<String> supportedVmwareSoftwareVersions) {
            this.supportedVmwareSoftwareVersions = supportedVmwareSoftwareVersions;
            this.__explicitlySet__.add("supportedVmwareSoftwareVersions");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isSupportShieldedInstances(Boolean isSupportShieldedInstances) {
            this.isSupportShieldedInstances = isSupportShieldedInstances;
            this.__explicitlySet__.add("isSupportShieldedInstances");
            return this;
        }

        public Builder isSupportMonthlyCommitment(Boolean isSupportMonthlyCommitment) {
            this.isSupportMonthlyCommitment = isSupportMonthlyCommitment;
            this.__explicitlySet__.add("isSupportMonthlyCommitment");
            return this;
        }

        public SupportedHostShapeSummary build() {
            SupportedHostShapeSummary model = new SupportedHostShapeSummary(this.name, this.supportedOperations, this.shapeFamily, this.defaultOcpuCount, this.supportedOcpuCount, this.isSingleHostSddcSupported, this.supportedVmwareSoftwareVersions, this.description, this.isSupportShieldedInstances, this.isSupportMonthlyCommitment);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SupportedHostShapeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("supportedOperations")) {
                this.supportedOperations(model.getSupportedOperations());
            }
            if (model.wasPropertyExplicitlySet("shapeFamily")) {
                this.shapeFamily(model.getShapeFamily());
            }
            if (model.wasPropertyExplicitlySet("defaultOcpuCount")) {
                this.defaultOcpuCount(model.getDefaultOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("supportedOcpuCount")) {
                this.supportedOcpuCount(model.getSupportedOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("isSingleHostSddcSupported")) {
                this.isSingleHostSddcSupported(model.getIsSingleHostSddcSupported());
            }
            if (model.wasPropertyExplicitlySet("supportedVmwareSoftwareVersions")) {
                this.supportedVmwareSoftwareVersions(model.getSupportedVmwareSoftwareVersions());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isSupportShieldedInstances")) {
                this.isSupportShieldedInstances(model.getIsSupportShieldedInstances());
            }
            if (model.wasPropertyExplicitlySet("isSupportMonthlyCommitment")) {
                this.isSupportMonthlyCommitment(model.getIsSupportMonthlyCommitment());
            }
            return this;
        }
    }
}

