/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.ocvp.model.ReplaceHostDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ReplaceHostRequest
extends BmcRequest<ReplaceHostDetails> {
    private String esxiHostId;
    private ReplaceHostDetails replaceHostDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getEsxiHostId() {
        return this.esxiHostId;
    }

    public ReplaceHostDetails getReplaceHostDetails() {
        return this.replaceHostDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ReplaceHostDetails getBody$() {
        return this.replaceHostDetails;
    }

    public Builder toBuilder() {
        return new Builder().esxiHostId(this.esxiHostId).replaceHostDetails(this.replaceHostDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",esxiHostId=").append(String.valueOf(this.esxiHostId));
        sb.append(",replaceHostDetails=").append(String.valueOf((Object)this.replaceHostDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplaceHostRequest)) {
            return false;
        }
        ReplaceHostRequest other = (ReplaceHostRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.esxiHostId, other.esxiHostId) && Objects.equals((Object)this.replaceHostDetails, (Object)other.replaceHostDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.esxiHostId == null ? 43 : this.esxiHostId.hashCode());
        result = result * 59 + (this.replaceHostDetails == null ? 43 : this.replaceHostDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ReplaceHostRequest, ReplaceHostDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String esxiHostId = null;
        private ReplaceHostDetails replaceHostDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder esxiHostId(String esxiHostId) {
            this.esxiHostId = esxiHostId;
            return this;
        }

        public Builder replaceHostDetails(ReplaceHostDetails replaceHostDetails) {
            this.replaceHostDetails = replaceHostDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ReplaceHostRequest o) {
            this.esxiHostId(o.getEsxiHostId());
            this.replaceHostDetails(o.getReplaceHostDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ReplaceHostRequest build() {
            ReplaceHostRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ReplaceHostDetails body) {
            this.replaceHostDetails(body);
            return this;
        }

        public ReplaceHostRequest buildWithoutInvocationCallback() {
            ReplaceHostRequest request = new ReplaceHostRequest();
            request.esxiHostId = this.esxiHostId;
            request.replaceHostDetails = this.replaceHostDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

