/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.oda.model.ExportSkillDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ExportSkillRequest
extends BmcRequest<ExportSkillDetails> {
    private String odaInstanceId;
    private String skillId;
    private ExportSkillDetails exportSkillDetails;
    private String opcRequestId;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getSkillId() {
        return this.skillId;
    }

    public ExportSkillDetails getExportSkillDetails() {
        return this.exportSkillDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ExportSkillDetails getBody$() {
        return this.exportSkillDetails;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).skillId(this.skillId).exportSkillDetails(this.exportSkillDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",skillId=").append(String.valueOf(this.skillId));
        sb.append(",exportSkillDetails=").append(String.valueOf((Object)this.exportSkillDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportSkillRequest)) {
            return false;
        }
        ExportSkillRequest other = (ExportSkillRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.skillId, other.skillId) && Objects.equals((Object)this.exportSkillDetails, (Object)other.exportSkillDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.skillId == null ? 43 : this.skillId.hashCode());
        result = result * 59 + (this.exportSkillDetails == null ? 43 : this.exportSkillDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportSkillRequest, ExportSkillDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String skillId = null;
        private ExportSkillDetails exportSkillDetails = null;
        private String opcRequestId = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Builder exportSkillDetails(ExportSkillDetails exportSkillDetails) {
            this.exportSkillDetails = exportSkillDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportSkillRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.skillId(o.getSkillId());
            this.exportSkillDetails(o.getExportSkillDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportSkillRequest build() {
            ExportSkillRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportSkillDetails body) {
            this.exportSkillDetails(body);
            return this;
        }

        public ExportSkillRequest buildWithoutInvocationCallback() {
            ExportSkillRequest request = new ExportSkillRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.skillId = this.skillId;
            request.exportSkillDetails = this.exportSkillDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

