/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOdaPrivateEndpointAttachmentRequest
extends BmcRequest<Void> {
    private String odaPrivateEndpointAttachmentId;
    private String opcRequestId;

    public String getOdaPrivateEndpointAttachmentId() {
        return this.odaPrivateEndpointAttachmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().odaPrivateEndpointAttachmentId(this.odaPrivateEndpointAttachmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaPrivateEndpointAttachmentId=").append(String.valueOf(this.odaPrivateEndpointAttachmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOdaPrivateEndpointAttachmentRequest)) {
            return false;
        }
        GetOdaPrivateEndpointAttachmentRequest other = (GetOdaPrivateEndpointAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaPrivateEndpointAttachmentId, other.odaPrivateEndpointAttachmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaPrivateEndpointAttachmentId == null ? 43 : this.odaPrivateEndpointAttachmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOdaPrivateEndpointAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaPrivateEndpointAttachmentId = null;
        private String opcRequestId = null;

        public Builder odaPrivateEndpointAttachmentId(String odaPrivateEndpointAttachmentId) {
            this.odaPrivateEndpointAttachmentId = odaPrivateEndpointAttachmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOdaPrivateEndpointAttachmentRequest o) {
            this.odaPrivateEndpointAttachmentId(o.getOdaPrivateEndpointAttachmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOdaPrivateEndpointAttachmentRequest build() {
            GetOdaPrivateEndpointAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOdaPrivateEndpointAttachmentRequest buildWithoutInvocationCallback() {
            GetOdaPrivateEndpointAttachmentRequest request = new GetOdaPrivateEndpointAttachmentRequest();
            request.odaPrivateEndpointAttachmentId = this.odaPrivateEndpointAttachmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

