/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.oda.Odapackage;
import com.oracle.bmc.oda.model.ImportedPackageSummary;
import com.oracle.bmc.oda.model.PackageSummary;
import com.oracle.bmc.oda.requests.ListImportedPackagesRequest;
import com.oracle.bmc.oda.requests.ListPackagesRequest;
import com.oracle.bmc.oda.responses.ListImportedPackagesResponse;
import com.oracle.bmc.oda.responses.ListPackagesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OdapackagePaginators {
    private final Odapackage client;

    public OdapackagePaginators(Odapackage client) {
        this.client = client;
    }

    public Iterable<ListImportedPackagesResponse> listImportedPackagesResponseIterator(final ListImportedPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListImportedPackagesRequest.Builder>(){

            @Override
            public ListImportedPackagesRequest.Builder get() {
                return ListImportedPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListImportedPackagesResponse, String>(){

            @Override
            public String apply(ListImportedPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListImportedPackagesRequest.Builder>, ListImportedPackagesRequest>(){

            @Override
            public ListImportedPackagesRequest apply(RequestBuilderAndToken<ListImportedPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListImportedPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListImportedPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListImportedPackagesRequest, ListImportedPackagesResponse>(){

            @Override
            public ListImportedPackagesResponse apply(ListImportedPackagesRequest request) {
                return OdapackagePaginators.this.client.listImportedPackages(request);
            }
        });
    }

    public Iterable<ImportedPackageSummary> listImportedPackagesRecordIterator(final ListImportedPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListImportedPackagesRequest.Builder>(){

            @Override
            public ListImportedPackagesRequest.Builder get() {
                return ListImportedPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListImportedPackagesResponse, String>(){

            @Override
            public String apply(ListImportedPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListImportedPackagesRequest.Builder>, ListImportedPackagesRequest>(){

            @Override
            public ListImportedPackagesRequest apply(RequestBuilderAndToken<ListImportedPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListImportedPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListImportedPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListImportedPackagesRequest, ListImportedPackagesResponse>(){

            @Override
            public ListImportedPackagesResponse apply(ListImportedPackagesRequest request) {
                return OdapackagePaginators.this.client.listImportedPackages(request);
            }
        }, (Function)new Function<ListImportedPackagesResponse, List<ImportedPackageSummary>>(){

            @Override
            public List<ImportedPackageSummary> apply(ListImportedPackagesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPackagesResponse> listPackagesResponseIterator(final ListPackagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPackagesRequest.Builder>(){

            @Override
            public ListPackagesRequest.Builder get() {
                return ListPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPackagesResponse, String>(){

            @Override
            public String apply(ListPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPackagesRequest.Builder>, ListPackagesRequest>(){

            @Override
            public ListPackagesRequest apply(RequestBuilderAndToken<ListPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPackagesRequest, ListPackagesResponse>(){

            @Override
            public ListPackagesResponse apply(ListPackagesRequest request) {
                return OdapackagePaginators.this.client.listPackages(request);
            }
        });
    }

    public Iterable<PackageSummary> listPackagesRecordIterator(final ListPackagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPackagesRequest.Builder>(){

            @Override
            public ListPackagesRequest.Builder get() {
                return ListPackagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPackagesResponse, String>(){

            @Override
            public String apply(ListPackagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPackagesRequest.Builder>, ListPackagesRequest>(){

            @Override
            public ListPackagesRequest apply(RequestBuilderAndToken<ListPackagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPackagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPackagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPackagesRequest, ListPackagesResponse>(){

            @Override
            public ListPackagesResponse apply(ListPackagesRequest request) {
                return OdapackagePaginators.this.client.listPackages(request);
            }
        }, (Function)new Function<ListPackagesResponse, List<PackageSummary>>(){

            @Override
            public List<PackageSummary> apply(ListPackagesResponse response) {
                return response.getItems();
            }
        });
    }
}

