/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.oda.model.OsvcServiceType;
import com.oracle.bmc.oda.model.UpdateChannelDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateOsvcChannelDetails
extends UpdateChannelDetails {
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="port")
    private final String port;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="totalSessionCount")
    private final Integer totalSessionCount;
    @JsonProperty(value="channelService")
    private final OsvcServiceType channelService;
    @JsonProperty(value="authenticationProviderName")
    private final String authenticationProviderName;
    @JsonProperty(value="botId")
    private final String botId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateOsvcChannelDetails(String name, String description, Long sessionExpiryDurationInMilliseconds, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String host, String port, String userName, String password, Integer totalSessionCount, OsvcServiceType channelService, String authenticationProviderName, String botId) {
        super(name, description, sessionExpiryDurationInMilliseconds, freeformTags, definedTags);
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.totalSessionCount = totalSessionCount;
        this.channelService = channelService;
        this.authenticationProviderName = authenticationProviderName;
        this.botId = botId;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getTotalSessionCount() {
        return this.totalSessionCount;
    }

    public OsvcServiceType getChannelService() {
        return this.channelService;
    }

    public String getAuthenticationProviderName() {
        return this.authenticationProviderName;
    }

    public String getBotId() {
        return this.botId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateOsvcChannelDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", host=").append(String.valueOf(this.host));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", password=").append("<redacted>");
        sb.append(", totalSessionCount=").append(String.valueOf(this.totalSessionCount));
        sb.append(", channelService=").append(String.valueOf((Object)this.channelService));
        sb.append(", authenticationProviderName=").append(String.valueOf(this.authenticationProviderName));
        sb.append(", botId=").append(String.valueOf(this.botId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateOsvcChannelDetails)) {
            return false;
        }
        UpdateOsvcChannelDetails other = (UpdateOsvcChannelDetails)((Object)o);
        return Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port) && Objects.equals(this.userName, other.userName) && Objects.equals(this.password, other.password) && Objects.equals(this.totalSessionCount, other.totalSessionCount) && Objects.equals((Object)this.channelService, (Object)other.channelService) && Objects.equals(this.authenticationProviderName, other.authenticationProviderName) && Objects.equals(this.botId, other.botId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.totalSessionCount == null ? 43 : this.totalSessionCount.hashCode());
        result = result * 59 + (this.channelService == null ? 43 : this.channelService.hashCode());
        result = result * 59 + (this.authenticationProviderName == null ? 43 : this.authenticationProviderName.hashCode());
        result = result * 59 + (this.botId == null ? 43 : this.botId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="sessionExpiryDurationInMilliseconds")
        private Long sessionExpiryDurationInMilliseconds;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="port")
        private String port;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="totalSessionCount")
        private Integer totalSessionCount;
        @JsonProperty(value="channelService")
        private OsvcServiceType channelService;
        @JsonProperty(value="authenticationProviderName")
        private String authenticationProviderName;
        @JsonProperty(value="botId")
        private String botId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder sessionExpiryDurationInMilliseconds(Long sessionExpiryDurationInMilliseconds) {
            this.sessionExpiryDurationInMilliseconds = sessionExpiryDurationInMilliseconds;
            this.__explicitlySet__.add("sessionExpiryDurationInMilliseconds");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder totalSessionCount(Integer totalSessionCount) {
            this.totalSessionCount = totalSessionCount;
            this.__explicitlySet__.add("totalSessionCount");
            return this;
        }

        public Builder channelService(OsvcServiceType channelService) {
            this.channelService = channelService;
            this.__explicitlySet__.add("channelService");
            return this;
        }

        public Builder authenticationProviderName(String authenticationProviderName) {
            this.authenticationProviderName = authenticationProviderName;
            this.__explicitlySet__.add("authenticationProviderName");
            return this;
        }

        public Builder botId(String botId) {
            this.botId = botId;
            this.__explicitlySet__.add("botId");
            return this;
        }

        public UpdateOsvcChannelDetails build() {
            UpdateOsvcChannelDetails model = new UpdateOsvcChannelDetails(this.name, this.description, this.sessionExpiryDurationInMilliseconds, this.freeformTags, this.definedTags, this.host, this.port, this.userName, this.password, this.totalSessionCount, this.channelService, this.authenticationProviderName, this.botId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateOsvcChannelDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("sessionExpiryDurationInMilliseconds")) {
                this.sessionExpiryDurationInMilliseconds(model.getSessionExpiryDurationInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("totalSessionCount")) {
                this.totalSessionCount(model.getTotalSessionCount());
            }
            if (model.wasPropertyExplicitlySet("channelService")) {
                this.channelService(model.getChannelService());
            }
            if (model.wasPropertyExplicitlySet("authenticationProviderName")) {
                this.authenticationProviderName(model.getAuthenticationProviderName());
            }
            if (model.wasPropertyExplicitlySet("botId")) {
                this.botId(model.getBotId());
            }
            return this;
        }
    }
}

