/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.oda.model.Channel;
import com.oracle.bmc.oda.model.ChannelCategory;
import com.oracle.bmc.oda.model.LifecycleState;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class WebChannel
extends Channel {
    @JsonProperty(value="maxTokenExpirationTimeInMinutes")
    private final Long maxTokenExpirationTimeInMinutes;
    @JsonProperty(value="isClientAuthenticationEnabled")
    private final Boolean isClientAuthenticationEnabled;
    @JsonProperty(value="allowedDomains")
    private final String allowedDomains;
    @JsonProperty(value="botId")
    private final String botId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public WebChannel(String id, String name, String description, ChannelCategory category, Long sessionExpiryDurationInMilliseconds, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Long maxTokenExpirationTimeInMinutes, Boolean isClientAuthenticationEnabled, String allowedDomains, String botId) {
        super(id, name, description, category, sessionExpiryDurationInMilliseconds, lifecycleState, timeCreated, timeUpdated, freeformTags, definedTags);
        this.maxTokenExpirationTimeInMinutes = maxTokenExpirationTimeInMinutes;
        this.isClientAuthenticationEnabled = isClientAuthenticationEnabled;
        this.allowedDomains = allowedDomains;
        this.botId = botId;
    }

    public Long getMaxTokenExpirationTimeInMinutes() {
        return this.maxTokenExpirationTimeInMinutes;
    }

    public Boolean getIsClientAuthenticationEnabled() {
        return this.isClientAuthenticationEnabled;
    }

    public String getAllowedDomains() {
        return this.allowedDomains;
    }

    public String getBotId() {
        return this.botId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WebChannel(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", maxTokenExpirationTimeInMinutes=").append(String.valueOf(this.maxTokenExpirationTimeInMinutes));
        sb.append(", isClientAuthenticationEnabled=").append(String.valueOf(this.isClientAuthenticationEnabled));
        sb.append(", allowedDomains=").append(String.valueOf(this.allowedDomains));
        sb.append(", botId=").append(String.valueOf(this.botId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebChannel)) {
            return false;
        }
        WebChannel other = (WebChannel)((Object)o);
        return Objects.equals(this.maxTokenExpirationTimeInMinutes, other.maxTokenExpirationTimeInMinutes) && Objects.equals(this.isClientAuthenticationEnabled, other.isClientAuthenticationEnabled) && Objects.equals(this.allowedDomains, other.allowedDomains) && Objects.equals(this.botId, other.botId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maxTokenExpirationTimeInMinutes == null ? 43 : this.maxTokenExpirationTimeInMinutes.hashCode());
        result = result * 59 + (this.isClientAuthenticationEnabled == null ? 43 : this.isClientAuthenticationEnabled.hashCode());
        result = result * 59 + (this.allowedDomains == null ? 43 : this.allowedDomains.hashCode());
        result = result * 59 + (this.botId == null ? 43 : this.botId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="category")
        private ChannelCategory category;
        @JsonProperty(value="sessionExpiryDurationInMilliseconds")
        private Long sessionExpiryDurationInMilliseconds;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="maxTokenExpirationTimeInMinutes")
        private Long maxTokenExpirationTimeInMinutes;
        @JsonProperty(value="isClientAuthenticationEnabled")
        private Boolean isClientAuthenticationEnabled;
        @JsonProperty(value="allowedDomains")
        private String allowedDomains;
        @JsonProperty(value="botId")
        private String botId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder category(ChannelCategory category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder sessionExpiryDurationInMilliseconds(Long sessionExpiryDurationInMilliseconds) {
            this.sessionExpiryDurationInMilliseconds = sessionExpiryDurationInMilliseconds;
            this.__explicitlySet__.add("sessionExpiryDurationInMilliseconds");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder maxTokenExpirationTimeInMinutes(Long maxTokenExpirationTimeInMinutes) {
            this.maxTokenExpirationTimeInMinutes = maxTokenExpirationTimeInMinutes;
            this.__explicitlySet__.add("maxTokenExpirationTimeInMinutes");
            return this;
        }

        public Builder isClientAuthenticationEnabled(Boolean isClientAuthenticationEnabled) {
            this.isClientAuthenticationEnabled = isClientAuthenticationEnabled;
            this.__explicitlySet__.add("isClientAuthenticationEnabled");
            return this;
        }

        public Builder allowedDomains(String allowedDomains) {
            this.allowedDomains = allowedDomains;
            this.__explicitlySet__.add("allowedDomains");
            return this;
        }

        public Builder botId(String botId) {
            this.botId = botId;
            this.__explicitlySet__.add("botId");
            return this;
        }

        public WebChannel build() {
            WebChannel model = new WebChannel(this.id, this.name, this.description, this.category, this.sessionExpiryDurationInMilliseconds, this.lifecycleState, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.maxTokenExpirationTimeInMinutes, this.isClientAuthenticationEnabled, this.allowedDomains, this.botId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WebChannel model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("sessionExpiryDurationInMilliseconds")) {
                this.sessionExpiryDurationInMilliseconds(model.getSessionExpiryDurationInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("maxTokenExpirationTimeInMinutes")) {
                this.maxTokenExpirationTimeInMinutes(model.getMaxTokenExpirationTimeInMinutes());
            }
            if (model.wasPropertyExplicitlySet("isClientAuthenticationEnabled")) {
                this.isClientAuthenticationEnabled(model.getIsClientAuthenticationEnabled());
            }
            if (model.wasPropertyExplicitlySet("allowedDomains")) {
                this.allowedDomains(model.getAllowedDomains());
            }
            if (model.wasPropertyExplicitlySet("botId")) {
                this.botId(model.getBotId());
            }
            return this;
        }
    }
}

