/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.oda.model.CreateSkillParameterDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateSkillParameterRequest
extends BmcRequest<CreateSkillParameterDetails> {
    private String odaInstanceId;
    private String skillId;
    private CreateSkillParameterDetails createSkillParameterDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getSkillId() {
        return this.skillId;
    }

    public CreateSkillParameterDetails getCreateSkillParameterDetails() {
        return this.createSkillParameterDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateSkillParameterDetails getBody$() {
        return this.createSkillParameterDetails;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).skillId(this.skillId).createSkillParameterDetails(this.createSkillParameterDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",skillId=").append(String.valueOf(this.skillId));
        sb.append(",createSkillParameterDetails=").append(String.valueOf((Object)this.createSkillParameterDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSkillParameterRequest)) {
            return false;
        }
        CreateSkillParameterRequest other = (CreateSkillParameterRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.skillId, other.skillId) && Objects.equals((Object)this.createSkillParameterDetails, (Object)other.createSkillParameterDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.skillId == null ? 43 : this.skillId.hashCode());
        result = result * 59 + (this.createSkillParameterDetails == null ? 43 : this.createSkillParameterDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateSkillParameterRequest, CreateSkillParameterDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String skillId = null;
        private CreateSkillParameterDetails createSkillParameterDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Builder createSkillParameterDetails(CreateSkillParameterDetails createSkillParameterDetails) {
            this.createSkillParameterDetails = createSkillParameterDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateSkillParameterRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.skillId(o.getSkillId());
            this.createSkillParameterDetails(o.getCreateSkillParameterDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateSkillParameterRequest build() {
            CreateSkillParameterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateSkillParameterDetails body) {
            this.createSkillParameterDetails(body);
            return this;
        }

        public CreateSkillParameterRequest buildWithoutInvocationCallback() {
            CreateSkillParameterRequest request = new CreateSkillParameterRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.skillId = this.skillId;
            request.createSkillParameterDetails = this.createSkillParameterDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

