/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.oda.model.ImportBotDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ImportBotRequest
extends BmcRequest<ImportBotDetails> {
    private String odaInstanceId;
    private ImportBotDetails importBotDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public ImportBotDetails getImportBotDetails() {
        return this.importBotDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ImportBotDetails getBody$() {
        return this.importBotDetails;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).importBotDetails(this.importBotDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",importBotDetails=").append(String.valueOf((Object)this.importBotDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportBotRequest)) {
            return false;
        }
        ImportBotRequest other = (ImportBotRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals((Object)this.importBotDetails, (Object)other.importBotDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.importBotDetails == null ? 43 : this.importBotDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportBotRequest, ImportBotDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private ImportBotDetails importBotDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder importBotDetails(ImportBotDetails importBotDetails) {
            this.importBotDetails = importBotDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportBotRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.importBotDetails(o.getImportBotDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportBotRequest build() {
            ImportBotRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportBotDetails body) {
            this.importBotDetails(body);
            return this;
        }

        public ImportBotRequest buildWithoutInvocationCallback() {
            ImportBotRequest request = new ImportBotRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.importBotDetails = this.importBotDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

