/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.oda.model.UpdateSkillDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSkillRequest
extends BmcRequest<UpdateSkillDetails> {
    private String odaInstanceId;
    private String skillId;
    private UpdateSkillDetails updateSkillDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getSkillId() {
        return this.skillId;
    }

    public UpdateSkillDetails getUpdateSkillDetails() {
        return this.updateSkillDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSkillDetails getBody$() {
        return this.updateSkillDetails;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).skillId(this.skillId).updateSkillDetails(this.updateSkillDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",skillId=").append(String.valueOf(this.skillId));
        sb.append(",updateSkillDetails=").append(String.valueOf((Object)this.updateSkillDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSkillRequest)) {
            return false;
        }
        UpdateSkillRequest other = (UpdateSkillRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.skillId, other.skillId) && Objects.equals((Object)this.updateSkillDetails, (Object)other.updateSkillDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.skillId == null ? 43 : this.skillId.hashCode());
        result = result * 59 + (this.updateSkillDetails == null ? 43 : this.updateSkillDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSkillRequest, UpdateSkillDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String skillId = null;
        private UpdateSkillDetails updateSkillDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Builder updateSkillDetails(UpdateSkillDetails updateSkillDetails) {
            this.updateSkillDetails = updateSkillDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSkillRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.skillId(o.getSkillId());
            this.updateSkillDetails(o.getUpdateSkillDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSkillRequest build() {
            UpdateSkillRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSkillDetails body) {
            this.updateSkillDetails(body);
            return this;
        }

        public UpdateSkillRequest buildWithoutInvocationCallback() {
            UpdateSkillRequest request = new UpdateSkillRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.skillId = this.skillId;
            request.updateSkillDetails = this.updateSkillDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

