/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.oda.OdaAsync;
import com.oracle.bmc.oda.model.OdaInstance;
import com.oracle.bmc.oda.model.OdaInstanceAttachment;
import com.oracle.bmc.oda.model.OdaInstanceAttachmentCollection;
import com.oracle.bmc.oda.model.OdaInstanceSummary;
import com.oracle.bmc.oda.model.WorkRequest;
import com.oracle.bmc.oda.model.WorkRequestError;
import com.oracle.bmc.oda.model.WorkRequestLogEntry;
import com.oracle.bmc.oda.model.WorkRequestSummary;
import com.oracle.bmc.oda.requests.ChangeOdaInstanceCompartmentRequest;
import com.oracle.bmc.oda.requests.CreateOdaInstanceAttachmentRequest;
import com.oracle.bmc.oda.requests.CreateOdaInstanceRequest;
import com.oracle.bmc.oda.requests.DeleteOdaInstanceAttachmentRequest;
import com.oracle.bmc.oda.requests.DeleteOdaInstanceRequest;
import com.oracle.bmc.oda.requests.GetOdaInstanceAttachmentRequest;
import com.oracle.bmc.oda.requests.GetOdaInstanceRequest;
import com.oracle.bmc.oda.requests.GetWorkRequestRequest;
import com.oracle.bmc.oda.requests.ListOdaInstanceAttachmentsRequest;
import com.oracle.bmc.oda.requests.ListOdaInstancesRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oda.requests.StartOdaInstanceRequest;
import com.oracle.bmc.oda.requests.StopOdaInstanceRequest;
import com.oracle.bmc.oda.requests.UpdateOdaInstanceAttachmentRequest;
import com.oracle.bmc.oda.requests.UpdateOdaInstanceRequest;
import com.oracle.bmc.oda.responses.ChangeOdaInstanceCompartmentResponse;
import com.oracle.bmc.oda.responses.CreateOdaInstanceAttachmentResponse;
import com.oracle.bmc.oda.responses.CreateOdaInstanceResponse;
import com.oracle.bmc.oda.responses.DeleteOdaInstanceAttachmentResponse;
import com.oracle.bmc.oda.responses.DeleteOdaInstanceResponse;
import com.oracle.bmc.oda.responses.GetOdaInstanceAttachmentResponse;
import com.oracle.bmc.oda.responses.GetOdaInstanceResponse;
import com.oracle.bmc.oda.responses.GetWorkRequestResponse;
import com.oracle.bmc.oda.responses.ListOdaInstanceAttachmentsResponse;
import com.oracle.bmc.oda.responses.ListOdaInstancesResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestsResponse;
import com.oracle.bmc.oda.responses.StartOdaInstanceResponse;
import com.oracle.bmc.oda.responses.StopOdaInstanceResponse;
import com.oracle.bmc.oda.responses.UpdateOdaInstanceAttachmentResponse;
import com.oracle.bmc.oda.responses.UpdateOdaInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdaAsyncClient
extends BaseAsyncClient
implements OdaAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ODA").serviceEndpointPrefix("").serviceEndpointTemplate("https://digitalassistant-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OdaAsyncClient.class);

    OdaAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeOdaInstanceCompartmentResponse> changeOdaInstanceCompartment(ChangeOdaInstanceCompartmentRequest request, AsyncHandler<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOdaInstanceCompartmentDetails(), "changeOdaInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeOdaInstanceCompartmentResponse::builder).logger(LOG, "changeOdaInstanceCompartment").serviceDetails("Oda", "ChangeOdaInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstance/ChangeOdaInstanceCompartment").method(Method.POST).requestBuilder(ChangeOdaInstanceCompartmentRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeOdaInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeOdaInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOdaInstanceResponse> createOdaInstance(CreateOdaInstanceRequest request, AsyncHandler<CreateOdaInstanceRequest, CreateOdaInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateOdaInstanceDetails(), "createOdaInstanceDetails is required");
        return this.clientCall(request, CreateOdaInstanceResponse::builder).logger(LOG, "createOdaInstance").serviceDetails("Oda", "CreateOdaInstance", "").method(Method.POST).requestBuilder(CreateOdaInstanceRequest::builder).basePath("/20190506").appendPathParam("odaInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(OdaInstance.class, CreateOdaInstanceResponse.Builder::odaInstance).handleResponseHeaderString("Location", CreateOdaInstanceResponse.Builder::location).handleResponseHeaderString("etag", CreateOdaInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateOdaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOdaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOdaInstanceAttachmentResponse> createOdaInstanceAttachment(CreateOdaInstanceAttachmentRequest request, AsyncHandler<CreateOdaInstanceAttachmentRequest, CreateOdaInstanceAttachmentResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateOdaInstanceAttachmentDetails(), "createOdaInstanceAttachmentDetails is required");
        return this.clientCall(request, CreateOdaInstanceAttachmentResponse::builder).logger(LOG, "createOdaInstanceAttachment").serviceDetails("Oda", "CreateOdaInstanceAttachment", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstanceAttachment/CreateOdaInstanceAttachment").method(Method.POST).requestBuilder(CreateOdaInstanceAttachmentRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("attachments").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateOdaInstanceAttachmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOdaInstanceAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOdaInstanceResponse> deleteOdaInstance(DeleteOdaInstanceRequest request, AsyncHandler<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOdaInstanceResponse::builder).logger(LOG, "deleteOdaInstance").serviceDetails("Oda", "DeleteOdaInstance", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstance/DeleteOdaInstance").method(Method.DELETE).requestBuilder(DeleteOdaInstanceRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendQueryParam("retentionTime", (Object)request.getRetentionTime()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOdaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOdaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOdaInstanceAttachmentResponse> deleteOdaInstanceAttachment(DeleteOdaInstanceAttachmentRequest request, AsyncHandler<DeleteOdaInstanceAttachmentRequest, DeleteOdaInstanceAttachmentResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttachmentId(), (String)"attachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOdaInstanceAttachmentResponse::builder).logger(LOG, "deleteOdaInstanceAttachment").serviceDetails("Oda", "DeleteOdaInstanceAttachment", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstanceAttachment/DeleteOdaInstanceAttachment").method(Method.DELETE).requestBuilder(DeleteOdaInstanceAttachmentRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("attachments").appendPathParam(request.getAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOdaInstanceAttachmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOdaInstanceAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOdaInstanceResponse> getOdaInstance(GetOdaInstanceRequest request, AsyncHandler<GetOdaInstanceRequest, GetOdaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOdaInstanceResponse::builder).logger(LOG, "getOdaInstance").serviceDetails("Oda", "GetOdaInstance", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstance/GetOdaInstance").method(Method.GET).requestBuilder(GetOdaInstanceRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OdaInstance.class, GetOdaInstanceResponse.Builder::odaInstance).handleResponseHeaderString("etag", GetOdaInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOdaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOdaInstanceAttachmentResponse> getOdaInstanceAttachment(GetOdaInstanceAttachmentRequest request, AsyncHandler<GetOdaInstanceAttachmentRequest, GetOdaInstanceAttachmentResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttachmentId(), (String)"attachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOdaInstanceAttachmentResponse::builder).logger(LOG, "getOdaInstanceAttachment").serviceDetails("Oda", "GetOdaInstanceAttachment", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstanceAttachment/GetOdaInstanceAttachment").method(Method.GET).requestBuilder(GetOdaInstanceAttachmentRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("attachments").appendPathParam(request.getAttachmentId()).appendQueryParam("includeOwnerMetadata", (Object)request.getIncludeOwnerMetadata()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OdaInstanceAttachment.class, GetOdaInstanceAttachmentResponse.Builder::odaInstanceAttachment).handleResponseHeaderString("etag", GetOdaInstanceAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOdaInstanceAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Oda", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190506").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListOdaInstanceAttachmentsResponse> listOdaInstanceAttachments(ListOdaInstanceAttachmentsRequest request, AsyncHandler<ListOdaInstanceAttachmentsRequest, ListOdaInstanceAttachmentsResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListOdaInstanceAttachmentsResponse::builder).logger(LOG, "listOdaInstanceAttachments").serviceDetails("Oda", "ListOdaInstanceAttachments", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstanceAttachmentCollection/ListOdaInstanceAttachments").method(Method.GET).requestBuilder(ListOdaInstanceAttachmentsRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("attachments").appendQueryParam("includeOwnerMetadata", (Object)request.getIncludeOwnerMetadata()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OdaInstanceAttachmentCollection.class, ListOdaInstanceAttachmentsResponse.Builder::odaInstanceAttachmentCollection).handleResponseHeaderString("opc-request-id", ListOdaInstanceAttachmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOdaInstanceAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListOdaInstanceAttachmentsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListOdaInstancesResponse> listOdaInstances(ListOdaInstancesRequest request, AsyncHandler<ListOdaInstancesRequest, ListOdaInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListOdaInstancesResponse::builder).logger(LOG, "listOdaInstances").serviceDetails("Oda", "ListOdaInstances", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstanceSummary/ListOdaInstances").method(Method.GET).requestBuilder(ListOdaInstancesRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(OdaInstanceSummary.class, ListOdaInstancesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListOdaInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOdaInstancesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListOdaInstancesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Oda", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190506").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListWorkRequestErrorsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Oda", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190506").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListWorkRequestLogsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Oda", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190506").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("odaInstanceId", (Object)request.getOdaInstanceId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListWorkRequestsResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<StartOdaInstanceResponse> startOdaInstance(StartOdaInstanceRequest request, AsyncHandler<StartOdaInstanceRequest, StartOdaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartOdaInstanceResponse::builder).logger(LOG, "startOdaInstance").serviceDetails("Oda", "StartOdaInstance", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstance/StartOdaInstance").method(Method.POST).requestBuilder(StartOdaInstanceRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartOdaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartOdaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopOdaInstanceResponse> stopOdaInstance(StopOdaInstanceRequest request, AsyncHandler<StopOdaInstanceRequest, StopOdaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopOdaInstanceResponse::builder).logger(LOG, "stopOdaInstance").serviceDetails("Oda", "StopOdaInstance", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstance/StopOdaInstance").method(Method.POST).requestBuilder(StopOdaInstanceRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StopOdaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopOdaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateOdaInstanceResponse> updateOdaInstance(UpdateOdaInstanceRequest request, AsyncHandler<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOdaInstanceDetails(), "updateOdaInstanceDetails is required");
        return this.clientCall(request, UpdateOdaInstanceResponse::builder).logger(LOG, "updateOdaInstance").serviceDetails("Oda", "UpdateOdaInstance", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstance/UpdateOdaInstance").method(Method.PUT).requestBuilder(UpdateOdaInstanceRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OdaInstance.class, UpdateOdaInstanceResponse.Builder::odaInstance).handleResponseHeaderString("etag", UpdateOdaInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOdaInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateOdaInstanceAttachmentResponse> updateOdaInstanceAttachment(UpdateOdaInstanceAttachmentRequest request, AsyncHandler<UpdateOdaInstanceAttachmentRequest, UpdateOdaInstanceAttachmentResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttachmentId(), (String)"attachmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOdaInstanceAttachmentDetails(), "updateOdaInstanceAttachmentDetails is required");
        return this.clientCall(request, UpdateOdaInstanceAttachmentResponse::builder).logger(LOG, "updateOdaInstanceAttachment").serviceDetails("Oda", "UpdateOdaInstanceAttachment", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/OdaInstanceAttachment/UpdateOdaInstanceAttachment").method(Method.PUT).requestBuilder(UpdateOdaInstanceAttachmentRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("attachments").appendPathParam(request.getAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateOdaInstanceAttachmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateOdaInstanceAttachmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public OdaAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OdaAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OdaAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OdaAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OdaAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OdaAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OdaAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OdaAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OdaAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OdaAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OdaAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "oda";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"oda");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OdaAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OdaAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

