/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.oda.OdapackageAsync;
import com.oracle.bmc.oda.model.ImportedPackage;
import com.oracle.bmc.oda.model.ImportedPackageSummary;
import com.oracle.bmc.oda.model.PackageItem;
import com.oracle.bmc.oda.model.PackageSummary;
import com.oracle.bmc.oda.requests.CreateImportedPackageRequest;
import com.oracle.bmc.oda.requests.DeleteImportedPackageRequest;
import com.oracle.bmc.oda.requests.GetImportedPackageRequest;
import com.oracle.bmc.oda.requests.GetPackageRequest;
import com.oracle.bmc.oda.requests.ListImportedPackagesRequest;
import com.oracle.bmc.oda.requests.ListPackagesRequest;
import com.oracle.bmc.oda.requests.UpdateImportedPackageRequest;
import com.oracle.bmc.oda.responses.CreateImportedPackageResponse;
import com.oracle.bmc.oda.responses.DeleteImportedPackageResponse;
import com.oracle.bmc.oda.responses.GetImportedPackageResponse;
import com.oracle.bmc.oda.responses.GetPackageResponse;
import com.oracle.bmc.oda.responses.ListImportedPackagesResponse;
import com.oracle.bmc.oda.responses.ListPackagesResponse;
import com.oracle.bmc.oda.responses.UpdateImportedPackageResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdapackageAsyncClient
extends BaseAsyncClient
implements OdapackageAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ODAPACKAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://digitalassistant-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OdapackageAsyncClient.class);

    OdapackageAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateImportedPackageResponse> createImportedPackage(CreateImportedPackageRequest request, AsyncHandler<CreateImportedPackageRequest, CreateImportedPackageResponse> handler) {
        Objects.requireNonNull(request.getCreateImportedPackageDetails(), "createImportedPackageDetails is required");
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateImportedPackageResponse::builder).logger(LOG, "createImportedPackage").serviceDetails("Odapackage", "CreateImportedPackage", "").method(Method.POST).requestBuilder(CreateImportedPackageRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("importedPackages").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ImportedPackage.class, CreateImportedPackageResponse.Builder::importedPackage).handleResponseHeaderString("Location", CreateImportedPackageResponse.Builder::location).handleResponseHeaderString("etag", CreateImportedPackageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateImportedPackageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateImportedPackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteImportedPackageResponse> deleteImportedPackage(DeleteImportedPackageRequest request, AsyncHandler<DeleteImportedPackageRequest, DeleteImportedPackageResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageId(), (String)"packageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteImportedPackageResponse::builder).logger(LOG, "deleteImportedPackage").serviceDetails("Odapackage", "DeleteImportedPackage", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/ImportedPackage/DeleteImportedPackage").method(Method.DELETE).requestBuilder(DeleteImportedPackageRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("importedPackages").appendPathParam(request.getPackageId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteImportedPackageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteImportedPackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetImportedPackageResponse> getImportedPackage(GetImportedPackageRequest request, AsyncHandler<GetImportedPackageRequest, GetImportedPackageResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageId(), (String)"packageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetImportedPackageResponse::builder).logger(LOG, "getImportedPackage").serviceDetails("Odapackage", "GetImportedPackage", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/ImportedPackage/GetImportedPackage").method(Method.GET).requestBuilder(GetImportedPackageRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("importedPackages").appendPathParam(request.getPackageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ImportedPackage.class, GetImportedPackageResponse.Builder::importedPackage).handleResponseHeaderString("opc-request-id", GetImportedPackageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetImportedPackageResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetPackageResponse> getPackage(GetPackageRequest request, AsyncHandler<GetPackageRequest, GetPackageResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageId(), (String)"packageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPackageResponse::builder).logger(LOG, "getPackage").serviceDetails("Odapackage", "GetPackage", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/PackageItem/GetPackage").method(Method.GET).requestBuilder(GetPackageRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("packages").appendPathParam(request.getPackageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PackageItem.class, GetPackageResponse.Builder::packageItem).handleResponseHeaderString("opc-request-id", GetPackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListImportedPackagesResponse> listImportedPackages(ListImportedPackagesRequest request, AsyncHandler<ListImportedPackagesRequest, ListImportedPackagesResponse> handler) {
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListImportedPackagesResponse::builder).logger(LOG, "listImportedPackages").serviceDetails("Odapackage", "ListImportedPackages", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/ImportedPackageSummary/ListImportedPackages").method(Method.GET).requestBuilder(ListImportedPackagesRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("importedPackages").appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ImportedPackageSummary.class, ListImportedPackagesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListImportedPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListImportedPackagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPackagesResponse> listPackages(ListPackagesRequest request, AsyncHandler<ListPackagesRequest, ListPackagesResponse> handler) {
        return this.clientCall(request, ListPackagesResponse::builder).logger(LOG, "listPackages").serviceDetails("Odapackage", "ListPackages", "https://docs.oracle.com/iaas/api/#/en/digital-assistant/20190506/PackageSummary/ListPackages").method(Method.GET).requestBuilder(ListPackagesRequest::builder).basePath("/20190506").appendPathParam("packages").appendQueryParam("odaInstanceId", (Object)request.getOdaInstanceId()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isLatestVersionOnly", (Object)request.getIsLatestVersionOnly()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PackageSummary.class, ListPackagesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListPackagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPackagesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListPackagesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<UpdateImportedPackageResponse> updateImportedPackage(UpdateImportedPackageRequest request, AsyncHandler<UpdateImportedPackageRequest, UpdateImportedPackageResponse> handler) {
        Objects.requireNonNull(request.getUpdateImportedPackageDetails(), "updateImportedPackageDetails is required");
        Validate.notBlank((String)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPackageId(), (String)"packageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateImportedPackageResponse::builder).logger(LOG, "updateImportedPackage").serviceDetails("Odapackage", "UpdateImportedPackage", "").method(Method.PUT).requestBuilder(UpdateImportedPackageRequest::builder).basePath("/20190506").appendPathParam("odaInstances").appendPathParam(request.getOdaInstanceId()).appendPathParam("importedPackages").appendPathParam(request.getPackageId()).appendQueryParam("isReplaceSkills", (Object)request.getIsReplaceSkills()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ImportedPackage.class, UpdateImportedPackageResponse.Builder::importedPackage).handleResponseHeaderString("Location", UpdateImportedPackageResponse.Builder::location).handleResponseHeaderString("etag", UpdateImportedPackageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateImportedPackageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateImportedPackageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OdapackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OdapackageAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OdapackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OdapackageAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OdapackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OdapackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OdapackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OdapackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OdapackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OdapackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OdapackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OdapackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OdapackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OdapackageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OdapackageAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "oda";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"oda");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OdapackageAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OdapackageAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

