/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.oda.model.ChannelCategory;
import com.oracle.bmc.oda.model.CreateChannelResult;
import com.oracle.bmc.oda.model.LifecycleState;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class CreateOSSChannelResult
extends CreateChannelResult {
    @JsonProperty(value="eventSinkBotIds")
    private final List<String> eventSinkBotIds;
    @JsonProperty(value="inboundMessageTopic")
    private final String inboundMessageTopic;
    @JsonProperty(value="outboundMessageTopic")
    private final String outboundMessageTopic;
    @JsonProperty(value="bootstrapServers")
    private final String bootstrapServers;
    @JsonProperty(value="securityProtocol")
    private final String securityProtocol;
    @JsonProperty(value="saslMechanism")
    private final String saslMechanism;
    @JsonProperty(value="tenancyName")
    private final String tenancyName;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="streamPoolId")
    private final String streamPoolId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateOSSChannelResult(String id, String name, String description, ChannelCategory category, Long sessionExpiryDurationInMilliseconds, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<String> eventSinkBotIds, String inboundMessageTopic, String outboundMessageTopic, String bootstrapServers, String securityProtocol, String saslMechanism, String tenancyName, String userName, String streamPoolId) {
        super(id, name, description, category, sessionExpiryDurationInMilliseconds, lifecycleState, timeCreated, timeUpdated, freeformTags, definedTags);
        this.eventSinkBotIds = eventSinkBotIds;
        this.inboundMessageTopic = inboundMessageTopic;
        this.outboundMessageTopic = outboundMessageTopic;
        this.bootstrapServers = bootstrapServers;
        this.securityProtocol = securityProtocol;
        this.saslMechanism = saslMechanism;
        this.tenancyName = tenancyName;
        this.userName = userName;
        this.streamPoolId = streamPoolId;
    }

    public List<String> getEventSinkBotIds() {
        return this.eventSinkBotIds;
    }

    public String getInboundMessageTopic() {
        return this.inboundMessageTopic;
    }

    public String getOutboundMessageTopic() {
        return this.outboundMessageTopic;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public String getTenancyName() {
        return this.tenancyName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getStreamPoolId() {
        return this.streamPoolId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateOSSChannelResult(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", eventSinkBotIds=").append(String.valueOf(this.eventSinkBotIds));
        sb.append(", inboundMessageTopic=").append(String.valueOf(this.inboundMessageTopic));
        sb.append(", outboundMessageTopic=").append(String.valueOf(this.outboundMessageTopic));
        sb.append(", bootstrapServers=").append(String.valueOf(this.bootstrapServers));
        sb.append(", securityProtocol=").append(String.valueOf(this.securityProtocol));
        sb.append(", saslMechanism=").append(String.valueOf(this.saslMechanism));
        sb.append(", tenancyName=").append(String.valueOf(this.tenancyName));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", streamPoolId=").append(String.valueOf(this.streamPoolId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOSSChannelResult)) {
            return false;
        }
        CreateOSSChannelResult other = (CreateOSSChannelResult)((Object)o);
        return Objects.equals(this.eventSinkBotIds, other.eventSinkBotIds) && Objects.equals(this.inboundMessageTopic, other.inboundMessageTopic) && Objects.equals(this.outboundMessageTopic, other.outboundMessageTopic) && Objects.equals(this.bootstrapServers, other.bootstrapServers) && Objects.equals(this.securityProtocol, other.securityProtocol) && Objects.equals(this.saslMechanism, other.saslMechanism) && Objects.equals(this.tenancyName, other.tenancyName) && Objects.equals(this.userName, other.userName) && Objects.equals(this.streamPoolId, other.streamPoolId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.eventSinkBotIds == null ? 43 : this.eventSinkBotIds.hashCode());
        result = result * 59 + (this.inboundMessageTopic == null ? 43 : this.inboundMessageTopic.hashCode());
        result = result * 59 + (this.outboundMessageTopic == null ? 43 : this.outboundMessageTopic.hashCode());
        result = result * 59 + (this.bootstrapServers == null ? 43 : this.bootstrapServers.hashCode());
        result = result * 59 + (this.securityProtocol == null ? 43 : this.securityProtocol.hashCode());
        result = result * 59 + (this.saslMechanism == null ? 43 : this.saslMechanism.hashCode());
        result = result * 59 + (this.tenancyName == null ? 43 : this.tenancyName.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.streamPoolId == null ? 43 : this.streamPoolId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="category")
        private ChannelCategory category;
        @JsonProperty(value="sessionExpiryDurationInMilliseconds")
        private Long sessionExpiryDurationInMilliseconds;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="eventSinkBotIds")
        private List<String> eventSinkBotIds;
        @JsonProperty(value="inboundMessageTopic")
        private String inboundMessageTopic;
        @JsonProperty(value="outboundMessageTopic")
        private String outboundMessageTopic;
        @JsonProperty(value="bootstrapServers")
        private String bootstrapServers;
        @JsonProperty(value="securityProtocol")
        private String securityProtocol;
        @JsonProperty(value="saslMechanism")
        private String saslMechanism;
        @JsonProperty(value="tenancyName")
        private String tenancyName;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="streamPoolId")
        private String streamPoolId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder category(ChannelCategory category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder sessionExpiryDurationInMilliseconds(Long sessionExpiryDurationInMilliseconds) {
            this.sessionExpiryDurationInMilliseconds = sessionExpiryDurationInMilliseconds;
            this.__explicitlySet__.add("sessionExpiryDurationInMilliseconds");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder eventSinkBotIds(List<String> eventSinkBotIds) {
            this.eventSinkBotIds = eventSinkBotIds;
            this.__explicitlySet__.add("eventSinkBotIds");
            return this;
        }

        public Builder inboundMessageTopic(String inboundMessageTopic) {
            this.inboundMessageTopic = inboundMessageTopic;
            this.__explicitlySet__.add("inboundMessageTopic");
            return this;
        }

        public Builder outboundMessageTopic(String outboundMessageTopic) {
            this.outboundMessageTopic = outboundMessageTopic;
            this.__explicitlySet__.add("outboundMessageTopic");
            return this;
        }

        public Builder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            this.__explicitlySet__.add("bootstrapServers");
            return this;
        }

        public Builder securityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
            this.__explicitlySet__.add("securityProtocol");
            return this;
        }

        public Builder saslMechanism(String saslMechanism) {
            this.saslMechanism = saslMechanism;
            this.__explicitlySet__.add("saslMechanism");
            return this;
        }

        public Builder tenancyName(String tenancyName) {
            this.tenancyName = tenancyName;
            this.__explicitlySet__.add("tenancyName");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder streamPoolId(String streamPoolId) {
            this.streamPoolId = streamPoolId;
            this.__explicitlySet__.add("streamPoolId");
            return this;
        }

        public CreateOSSChannelResult build() {
            CreateOSSChannelResult model = new CreateOSSChannelResult(this.id, this.name, this.description, this.category, this.sessionExpiryDurationInMilliseconds, this.lifecycleState, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags, this.eventSinkBotIds, this.inboundMessageTopic, this.outboundMessageTopic, this.bootstrapServers, this.securityProtocol, this.saslMechanism, this.tenancyName, this.userName, this.streamPoolId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateOSSChannelResult model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("sessionExpiryDurationInMilliseconds")) {
                this.sessionExpiryDurationInMilliseconds(model.getSessionExpiryDurationInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("eventSinkBotIds")) {
                this.eventSinkBotIds(model.getEventSinkBotIds());
            }
            if (model.wasPropertyExplicitlySet("inboundMessageTopic")) {
                this.inboundMessageTopic(model.getInboundMessageTopic());
            }
            if (model.wasPropertyExplicitlySet("outboundMessageTopic")) {
                this.outboundMessageTopic(model.getOutboundMessageTopic());
            }
            if (model.wasPropertyExplicitlySet("bootstrapServers")) {
                this.bootstrapServers(model.getBootstrapServers());
            }
            if (model.wasPropertyExplicitlySet("securityProtocol")) {
                this.securityProtocol(model.getSecurityProtocol());
            }
            if (model.wasPropertyExplicitlySet("saslMechanism")) {
                this.saslMechanism(model.getSaslMechanism());
            }
            if (model.wasPropertyExplicitlySet("tenancyName")) {
                this.tenancyName(model.getTenancyName());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("streamPoolId")) {
                this.streamPoolId(model.getStreamPoolId());
            }
            return this;
        }
    }
}

