/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.oda.model.CreateSkillEntityDetails;
import com.oracle.bmc.oda.model.EntityAction;
import com.oracle.bmc.oda.model.EntityAttribute;
import com.oracle.bmc.oda.model.EntityNaturalLanguageMapping;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class CreateSkillCompositeEntityDetails
extends CreateSkillEntityDetails {
    @JsonProperty(value="attributes")
    private final List<EntityAttribute> attributes;
    @JsonProperty(value="actions")
    private final List<EntityAction> actions;
    @JsonProperty(value="naturalLanguageMapping")
    private final EntityNaturalLanguageMapping naturalLanguageMapping;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateSkillCompositeEntityDetails(String name, List<EntityAttribute> attributes, List<EntityAction> actions, EntityNaturalLanguageMapping naturalLanguageMapping) {
        super(name);
        this.attributes = attributes;
        this.actions = actions;
        this.naturalLanguageMapping = naturalLanguageMapping;
    }

    public List<EntityAttribute> getAttributes() {
        return this.attributes;
    }

    public List<EntityAction> getActions() {
        return this.actions;
    }

    public EntityNaturalLanguageMapping getNaturalLanguageMapping() {
        return this.naturalLanguageMapping;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSkillCompositeEntityDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", attributes=").append(String.valueOf(this.attributes));
        sb.append(", actions=").append(String.valueOf(this.actions));
        sb.append(", naturalLanguageMapping=").append(String.valueOf((Object)this.naturalLanguageMapping));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSkillCompositeEntityDetails)) {
            return false;
        }
        CreateSkillCompositeEntityDetails other = (CreateSkillCompositeEntityDetails)((Object)o);
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.actions, other.actions) && Objects.equals((Object)this.naturalLanguageMapping, (Object)other.naturalLanguageMapping) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.attributes == null ? 43 : this.attributes.hashCode());
        result = result * 59 + (this.actions == null ? 43 : this.actions.hashCode());
        result = result * 59 + (this.naturalLanguageMapping == null ? 43 : this.naturalLanguageMapping.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="attributes")
        private List<EntityAttribute> attributes;
        @JsonProperty(value="actions")
        private List<EntityAction> actions;
        @JsonProperty(value="naturalLanguageMapping")
        private EntityNaturalLanguageMapping naturalLanguageMapping;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder attributes(List<EntityAttribute> attributes) {
            this.attributes = attributes;
            this.__explicitlySet__.add("attributes");
            return this;
        }

        public Builder actions(List<EntityAction> actions) {
            this.actions = actions;
            this.__explicitlySet__.add("actions");
            return this;
        }

        public Builder naturalLanguageMapping(EntityNaturalLanguageMapping naturalLanguageMapping) {
            this.naturalLanguageMapping = naturalLanguageMapping;
            this.__explicitlySet__.add("naturalLanguageMapping");
            return this;
        }

        public CreateSkillCompositeEntityDetails build() {
            CreateSkillCompositeEntityDetails model = new CreateSkillCompositeEntityDetails(this.name, this.attributes, this.actions, this.naturalLanguageMapping);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSkillCompositeEntityDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("attributes")) {
                this.attributes(model.getAttributes());
            }
            if (model.wasPropertyExplicitlySet("actions")) {
                this.actions(model.getActions());
            }
            if (model.wasPropertyExplicitlySet("naturalLanguageMapping")) {
                this.naturalLanguageMapping(model.getNaturalLanguageMapping());
            }
            return this;
        }
    }
}

