/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.oda.model.EntityActionArgument;
import com.oracle.bmc.oda.model.EntityActionNaturalLanguageMapping;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntityAction
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="crudType")
    private final String crudType;
    @JsonProperty(value="naturalLanguageMapping")
    private final EntityActionNaturalLanguageMapping naturalLanguageMapping;
    @JsonProperty(value="arguments")
    private final List<EntityActionArgument> arguments;

    @Deprecated
    @ConstructorProperties(value={"name", "crudType", "naturalLanguageMapping", "arguments"})
    public EntityAction(String name, String crudType, EntityActionNaturalLanguageMapping naturalLanguageMapping, List<EntityActionArgument> arguments) {
        this.name = name;
        this.crudType = crudType;
        this.naturalLanguageMapping = naturalLanguageMapping;
        this.arguments = arguments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getCrudType() {
        return this.crudType;
    }

    public EntityActionNaturalLanguageMapping getNaturalLanguageMapping() {
        return this.naturalLanguageMapping;
    }

    public List<EntityActionArgument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityAction(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", crudType=").append(String.valueOf(this.crudType));
        sb.append(", naturalLanguageMapping=").append(String.valueOf((Object)this.naturalLanguageMapping));
        sb.append(", arguments=").append(String.valueOf(this.arguments));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityAction)) {
            return false;
        }
        EntityAction other = (EntityAction)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.crudType, other.crudType) && Objects.equals((Object)this.naturalLanguageMapping, (Object)other.naturalLanguageMapping) && Objects.equals(this.arguments, other.arguments) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.crudType == null ? 43 : this.crudType.hashCode());
        result = result * 59 + (this.naturalLanguageMapping == null ? 43 : this.naturalLanguageMapping.hashCode());
        result = result * 59 + (this.arguments == null ? 43 : this.arguments.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="crudType")
        private String crudType;
        @JsonProperty(value="naturalLanguageMapping")
        private EntityActionNaturalLanguageMapping naturalLanguageMapping;
        @JsonProperty(value="arguments")
        private List<EntityActionArgument> arguments;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder crudType(String crudType) {
            this.crudType = crudType;
            this.__explicitlySet__.add("crudType");
            return this;
        }

        public Builder naturalLanguageMapping(EntityActionNaturalLanguageMapping naturalLanguageMapping) {
            this.naturalLanguageMapping = naturalLanguageMapping;
            this.__explicitlySet__.add("naturalLanguageMapping");
            return this;
        }

        public Builder arguments(List<EntityActionArgument> arguments) {
            this.arguments = arguments;
            this.__explicitlySet__.add("arguments");
            return this;
        }

        public EntityAction build() {
            EntityAction model = new EntityAction(this.name, this.crudType, this.naturalLanguageMapping, this.arguments);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntityAction model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("crudType")) {
                this.crudType(model.getCrudType());
            }
            if (model.wasPropertyExplicitlySet("naturalLanguageMapping")) {
                this.naturalLanguageMapping(model.getNaturalLanguageMapping());
            }
            if (model.wasPropertyExplicitlySet("arguments")) {
                this.arguments(model.getArguments());
            }
            return this;
        }
    }
}

