/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.oda.model.EntityActionArgumentNaturalLanguageMapping;
import com.oracle.bmc.oda.model.EntityAttributeType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntityActionArgument
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final EntityAttributeType type;
    @JsonProperty(value="metaType")
    private final String metaType;
    @JsonProperty(value="naturalLanguageMapping")
    private final EntityActionArgumentNaturalLanguageMapping naturalLanguageMapping;
    @JsonProperty(value="isMultiValue")
    private final Boolean isMultiValue;
    @JsonProperty(value="entityName")
    private final String entityName;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "metaType", "naturalLanguageMapping", "isMultiValue", "entityName"})
    public EntityActionArgument(String name, EntityAttributeType type, String metaType, EntityActionArgumentNaturalLanguageMapping naturalLanguageMapping, Boolean isMultiValue, String entityName) {
        this.name = name;
        this.type = type;
        this.metaType = metaType;
        this.naturalLanguageMapping = naturalLanguageMapping;
        this.isMultiValue = isMultiValue;
        this.entityName = entityName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public EntityAttributeType getType() {
        return this.type;
    }

    public String getMetaType() {
        return this.metaType;
    }

    public EntityActionArgumentNaturalLanguageMapping getNaturalLanguageMapping() {
        return this.naturalLanguageMapping;
    }

    public Boolean getIsMultiValue() {
        return this.isMultiValue;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityActionArgument(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", metaType=").append(String.valueOf(this.metaType));
        sb.append(", naturalLanguageMapping=").append(String.valueOf((Object)this.naturalLanguageMapping));
        sb.append(", isMultiValue=").append(String.valueOf(this.isMultiValue));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityActionArgument)) {
            return false;
        }
        EntityActionArgument other = (EntityActionArgument)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.metaType, other.metaType) && Objects.equals((Object)this.naturalLanguageMapping, (Object)other.naturalLanguageMapping) && Objects.equals(this.isMultiValue, other.isMultiValue) && Objects.equals(this.entityName, other.entityName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.metaType == null ? 43 : this.metaType.hashCode());
        result = result * 59 + (this.naturalLanguageMapping == null ? 43 : this.naturalLanguageMapping.hashCode());
        result = result * 59 + (this.isMultiValue == null ? 43 : this.isMultiValue.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private EntityAttributeType type;
        @JsonProperty(value="metaType")
        private String metaType;
        @JsonProperty(value="naturalLanguageMapping")
        private EntityActionArgumentNaturalLanguageMapping naturalLanguageMapping;
        @JsonProperty(value="isMultiValue")
        private Boolean isMultiValue;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(EntityAttributeType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder metaType(String metaType) {
            this.metaType = metaType;
            this.__explicitlySet__.add("metaType");
            return this;
        }

        public Builder naturalLanguageMapping(EntityActionArgumentNaturalLanguageMapping naturalLanguageMapping) {
            this.naturalLanguageMapping = naturalLanguageMapping;
            this.__explicitlySet__.add("naturalLanguageMapping");
            return this;
        }

        public Builder isMultiValue(Boolean isMultiValue) {
            this.isMultiValue = isMultiValue;
            this.__explicitlySet__.add("isMultiValue");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public EntityActionArgument build() {
            EntityActionArgument model = new EntityActionArgument(this.name, this.type, this.metaType, this.naturalLanguageMapping, this.isMultiValue, this.entityName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntityActionArgument model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("metaType")) {
                this.metaType(model.getMetaType());
            }
            if (model.wasPropertyExplicitlySet("naturalLanguageMapping")) {
                this.naturalLanguageMapping(model.getNaturalLanguageMapping());
            }
            if (model.wasPropertyExplicitlySet("isMultiValue")) {
                this.isMultiValue(model.getIsMultiValue());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            return this;
        }
    }
}

