/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.oda.model.EntityAttributeNaturalLanguageMapping;
import com.oracle.bmc.oda.model.EntityAttributeType;
import com.oracle.bmc.oda.model.TemporalPreference;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntityAttribute
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final EntityAttributeType type;
    @JsonProperty(value="naturalLanguageMapping")
    private final EntityAttributeNaturalLanguageMapping naturalLanguageMapping;
    @JsonProperty(value="isMultiValue")
    private final Boolean isMultiValue;
    @JsonProperty(value="isFuzzyMatch")
    private final Boolean isFuzzyMatch;
    @JsonProperty(value="isInvertComparisons")
    private final Boolean isInvertComparisons;
    @JsonProperty(value="temporalPreference")
    private final TemporalPreference temporalPreference;
    @JsonProperty(value="entityName")
    private final String entityName;

    @Deprecated
    @ConstructorProperties(value={"name", "type", "naturalLanguageMapping", "isMultiValue", "isFuzzyMatch", "isInvertComparisons", "temporalPreference", "entityName"})
    public EntityAttribute(String name, EntityAttributeType type, EntityAttributeNaturalLanguageMapping naturalLanguageMapping, Boolean isMultiValue, Boolean isFuzzyMatch, Boolean isInvertComparisons, TemporalPreference temporalPreference, String entityName) {
        this.name = name;
        this.type = type;
        this.naturalLanguageMapping = naturalLanguageMapping;
        this.isMultiValue = isMultiValue;
        this.isFuzzyMatch = isFuzzyMatch;
        this.isInvertComparisons = isInvertComparisons;
        this.temporalPreference = temporalPreference;
        this.entityName = entityName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public EntityAttributeType getType() {
        return this.type;
    }

    public EntityAttributeNaturalLanguageMapping getNaturalLanguageMapping() {
        return this.naturalLanguageMapping;
    }

    public Boolean getIsMultiValue() {
        return this.isMultiValue;
    }

    public Boolean getIsFuzzyMatch() {
        return this.isFuzzyMatch;
    }

    public Boolean getIsInvertComparisons() {
        return this.isInvertComparisons;
    }

    public TemporalPreference getTemporalPreference() {
        return this.temporalPreference;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityAttribute(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", naturalLanguageMapping=").append(String.valueOf((Object)this.naturalLanguageMapping));
        sb.append(", isMultiValue=").append(String.valueOf(this.isMultiValue));
        sb.append(", isFuzzyMatch=").append(String.valueOf(this.isFuzzyMatch));
        sb.append(", isInvertComparisons=").append(String.valueOf(this.isInvertComparisons));
        sb.append(", temporalPreference=").append(String.valueOf((Object)this.temporalPreference));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityAttribute)) {
            return false;
        }
        EntityAttribute other = (EntityAttribute)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.naturalLanguageMapping, (Object)other.naturalLanguageMapping) && Objects.equals(this.isMultiValue, other.isMultiValue) && Objects.equals(this.isFuzzyMatch, other.isFuzzyMatch) && Objects.equals(this.isInvertComparisons, other.isInvertComparisons) && Objects.equals((Object)this.temporalPreference, (Object)other.temporalPreference) && Objects.equals(this.entityName, other.entityName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.naturalLanguageMapping == null ? 43 : this.naturalLanguageMapping.hashCode());
        result = result * 59 + (this.isMultiValue == null ? 43 : this.isMultiValue.hashCode());
        result = result * 59 + (this.isFuzzyMatch == null ? 43 : this.isFuzzyMatch.hashCode());
        result = result * 59 + (this.isInvertComparisons == null ? 43 : this.isInvertComparisons.hashCode());
        result = result * 59 + (this.temporalPreference == null ? 43 : this.temporalPreference.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private EntityAttributeType type;
        @JsonProperty(value="naturalLanguageMapping")
        private EntityAttributeNaturalLanguageMapping naturalLanguageMapping;
        @JsonProperty(value="isMultiValue")
        private Boolean isMultiValue;
        @JsonProperty(value="isFuzzyMatch")
        private Boolean isFuzzyMatch;
        @JsonProperty(value="isInvertComparisons")
        private Boolean isInvertComparisons;
        @JsonProperty(value="temporalPreference")
        private TemporalPreference temporalPreference;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(EntityAttributeType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder naturalLanguageMapping(EntityAttributeNaturalLanguageMapping naturalLanguageMapping) {
            this.naturalLanguageMapping = naturalLanguageMapping;
            this.__explicitlySet__.add("naturalLanguageMapping");
            return this;
        }

        public Builder isMultiValue(Boolean isMultiValue) {
            this.isMultiValue = isMultiValue;
            this.__explicitlySet__.add("isMultiValue");
            return this;
        }

        public Builder isFuzzyMatch(Boolean isFuzzyMatch) {
            this.isFuzzyMatch = isFuzzyMatch;
            this.__explicitlySet__.add("isFuzzyMatch");
            return this;
        }

        public Builder isInvertComparisons(Boolean isInvertComparisons) {
            this.isInvertComparisons = isInvertComparisons;
            this.__explicitlySet__.add("isInvertComparisons");
            return this;
        }

        public Builder temporalPreference(TemporalPreference temporalPreference) {
            this.temporalPreference = temporalPreference;
            this.__explicitlySet__.add("temporalPreference");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public EntityAttribute build() {
            EntityAttribute model = new EntityAttribute(this.name, this.type, this.naturalLanguageMapping, this.isMultiValue, this.isFuzzyMatch, this.isInvertComparisons, this.temporalPreference, this.entityName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntityAttribute model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("naturalLanguageMapping")) {
                this.naturalLanguageMapping(model.getNaturalLanguageMapping());
            }
            if (model.wasPropertyExplicitlySet("isMultiValue")) {
                this.isMultiValue(model.getIsMultiValue());
            }
            if (model.wasPropertyExplicitlySet("isFuzzyMatch")) {
                this.isFuzzyMatch(model.getIsFuzzyMatch());
            }
            if (model.wasPropertyExplicitlySet("isInvertComparisons")) {
                this.isInvertComparisons(model.getIsInvertComparisons());
            }
            if (model.wasPropertyExplicitlySet("temporalPreference")) {
                this.temporalPreference(model.getTemporalPreference());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            return this;
        }
    }
}

