/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOdaPrivateEndpointRequest
extends BmcRequest<Void> {
    private String odaPrivateEndpointId;
    private String opcRequestId;

    public String getOdaPrivateEndpointId() {
        return this.odaPrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().odaPrivateEndpointId(this.odaPrivateEndpointId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaPrivateEndpointId=").append(String.valueOf(this.odaPrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOdaPrivateEndpointRequest)) {
            return false;
        }
        GetOdaPrivateEndpointRequest other = (GetOdaPrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaPrivateEndpointId, other.odaPrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaPrivateEndpointId == null ? 43 : this.odaPrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOdaPrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaPrivateEndpointId = null;
        private String opcRequestId = null;

        public Builder odaPrivateEndpointId(String odaPrivateEndpointId) {
            this.odaPrivateEndpointId = odaPrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOdaPrivateEndpointRequest o) {
            this.odaPrivateEndpointId(o.getOdaPrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOdaPrivateEndpointRequest build() {
            GetOdaPrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOdaPrivateEndpointRequest buildWithoutInvocationCallback() {
            GetOdaPrivateEndpointRequest request = new GetOdaPrivateEndpointRequest();
            request.odaPrivateEndpointId = this.odaPrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

