/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RotateChannelKeysRequest
extends BmcRequest<Void> {
    private String odaInstanceId;
    private String channelId;
    private String opcRequestId;
    private String ifMatch;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).channelId(this.channelId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",channelId=").append(String.valueOf(this.channelId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RotateChannelKeysRequest)) {
            return false;
        }
        RotateChannelKeysRequest other = (RotateChannelKeysRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.channelId, other.channelId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.channelId == null ? 43 : this.channelId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RotateChannelKeysRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String channelId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RotateChannelKeysRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.channelId(o.getChannelId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RotateChannelKeysRequest build() {
            RotateChannelKeysRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RotateChannelKeysRequest buildWithoutInvocationCallback() {
            RotateChannelKeysRequest request = new RotateChannelKeysRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.channelId = this.channelId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

