/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.oda.model.TrainSkillDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TrainSkillRequest
extends BmcRequest<TrainSkillDetails> {
    private String odaInstanceId;
    private String skillId;
    private TrainSkillDetails trainSkillDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getSkillId() {
        return this.skillId;
    }

    public TrainSkillDetails getTrainSkillDetails() {
        return this.trainSkillDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public TrainSkillDetails getBody$() {
        return this.trainSkillDetails;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).skillId(this.skillId).trainSkillDetails(this.trainSkillDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",skillId=").append(String.valueOf(this.skillId));
        sb.append(",trainSkillDetails=").append(String.valueOf((Object)this.trainSkillDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrainSkillRequest)) {
            return false;
        }
        TrainSkillRequest other = (TrainSkillRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.skillId, other.skillId) && Objects.equals((Object)this.trainSkillDetails, (Object)other.trainSkillDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.skillId == null ? 43 : this.skillId.hashCode());
        result = result * 59 + (this.trainSkillDetails == null ? 43 : this.trainSkillDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TrainSkillRequest, TrainSkillDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String skillId = null;
        private TrainSkillDetails trainSkillDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Builder trainSkillDetails(TrainSkillDetails trainSkillDetails) {
            this.trainSkillDetails = trainSkillDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TrainSkillRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.skillId(o.getSkillId());
            this.trainSkillDetails(o.getTrainSkillDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TrainSkillRequest build() {
            TrainSkillRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TrainSkillDetails body) {
            this.trainSkillDetails(body);
            return this;
        }

        public TrainSkillRequest buildWithoutInvocationCallback() {
            TrainSkillRequest request = new TrainSkillRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.skillId = this.skillId;
            request.trainSkillDetails = this.trainSkillDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

