/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.onesubscription.InvoiceSummary;
import com.oracle.bmc.onesubscription.InvoiceSummaryPaginators;
import com.oracle.bmc.onesubscription.model.InvoicelineComputedUsageSummary;
import com.oracle.bmc.onesubscription.requests.ListInvoicelineComputedUsagesRequest;
import com.oracle.bmc.onesubscription.requests.ListInvoicesRequest;
import com.oracle.bmc.onesubscription.responses.ListInvoicelineComputedUsagesResponse;
import com.oracle.bmc.onesubscription.responses.ListInvoicesResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceSummaryClient
extends BaseSyncClient
implements InvoiceSummary {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INVOICESUMMARY").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(InvoiceSummaryClient.class);
    private final InvoiceSummaryPaginators paginators = new InvoiceSummaryPaginators(this);

    InvoiceSummaryClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListInvoicelineComputedUsagesResponse listInvoicelineComputedUsages(ListInvoicelineComputedUsagesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getInvoiceLineId(), "invoiceLineId is required");
        return (ListInvoicelineComputedUsagesResponse)this.clientCall(request, ListInvoicelineComputedUsagesResponse::builder).logger(LOG, "listInvoicelineComputedUsages").serviceDetails("InvoiceSummary", "ListInvoicelineComputedUsages", "").method(Method.GET).requestBuilder(ListInvoicelineComputedUsagesRequest::builder).basePath("/20190111").appendPathParam("invoiceLineComputedUsages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("invoiceLineId", (Object)request.getInvoiceLineId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InvoicelineComputedUsageSummary.class, ListInvoicelineComputedUsagesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInvoicelineComputedUsagesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInvoicelineComputedUsagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListInvoicesResponse listInvoices(ListInvoicesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getArCustomerTransactionId(), "arCustomerTransactionId is required");
        return (ListInvoicesResponse)this.clientCall(request, ListInvoicesResponse::builder).logger(LOG, "listInvoices").serviceDetails("InvoiceSummary", "ListInvoices", "").method(Method.GET).requestBuilder(ListInvoicesRequest::builder).basePath("/20190111").appendPathParam("invoice").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("arCustomerTransactionId", (Object)request.getArCustomerTransactionId()).appendQueryParam("timeFrom", (Object)request.getTimeFrom()).appendQueryParam("timeTo", (Object)request.getTimeTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(com.oracle.bmc.onesubscription.model.InvoiceSummary.class, ListInvoicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInvoicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInvoicesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public InvoiceSummaryPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public InvoiceSummaryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)InvoiceSummaryClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(InvoiceSummaryClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)InvoiceSummaryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)InvoiceSummaryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)InvoiceSummaryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)InvoiceSummaryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)InvoiceSummaryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, InvoiceSummaryClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "onesubscription";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"onesubscription");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public InvoiceSummaryClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new InvoiceSummaryClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

